/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceMethodInvoker;
import com.alipay.sofa.rpc.tracer.Tracers;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;

public class RestTracerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTracerAdapter.class);
    private static final String METHOD_TYPE_STRING = "_method_type_string";

    public static void beforeSend(ClientRequestContext requestContext) {
        String appName;
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.getCurrentSpan();
        RpcInternalContext context = RpcInternalContext.getContext();
        if (clientSpan != null) {
            requestContext.getHeaders().add((Object)"new_rpc_trace_context", (Object)clientSpan.getSofaTracerSpanContext().serializeSpanContext());
        }
        if ((appName = (String)context.getAttachment("_app_name")) != null) {
            requestContext.getHeaders().add((Object)"app", (Object)appName);
        }
        RestBaggageItemsHandler.encodeBaggageItemToRequest((MultivaluedMap<String, Object>)requestContext.getHeaders());
    }

    public static void serverReceived(NettyHttpRequest request) {
        block7: {
            try {
                SofaRequest sofaRequest = new SofaRequest();
                HttpHeaders headers = request.getHttpHeaders();
                String rpcTraceContext = headers.getHeaderString("new_rpc_trace_context");
                if (StringUtils.isNotBlank(rpcTraceContext)) {
                    sofaRequest.addRequestProp("new_rpc_trace_context", rpcTraceContext);
                } else {
                    String traceIdKey = headers.getHeaderString("SOFA-TraceId");
                    String rpcIdKey = headers.getHeaderString("SOFA-RpcId");
                    if (StringUtils.isEmpty(rpcIdKey)) {
                        rpcIdKey = (String)request.getUri().getQueryParameters().getFirst((Object)"sofaRpcId");
                    }
                    if (StringUtils.isEmpty(traceIdKey)) {
                        traceIdKey = (String)request.getUri().getQueryParameters().getFirst((Object)"sofaTraceId");
                    }
                    if (StringUtils.isNotEmpty(traceIdKey) && StringUtils.isNotEmpty(rpcIdKey)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("sofaTraceId", traceIdKey);
                        map.put("sofaRpcId", rpcIdKey);
                        String penAttrs = headers.getHeaderString("sofaPenAttrs");
                        map.put("sofaPenAttrs", penAttrs);
                        sofaRequest.addRequestProp("rpc_trace_context", map);
                    }
                }
                Tracers.serverReceived(sofaRequest);
                RestBaggageItemsHandler.decodeBaggageItemsFromRequest(request, sofaRequest);
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("the process of rest tracer server receive occur error ", t);
            }
        }
    }

    public static void serverFilter(ContainerRequestContext requestContext) {
        block7: {
            try {
                SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
                SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
                if (serverSpan != null) {
                    RpcInternalContext context = RpcInternalContext.getContext();
                    context.setAttachment("_server_receive_time", RpcRuntimeContext.now());
                    SofaResourceMethodInvoker resourceMethodInvoker = (SofaResourceMethodInvoker)((PostMatchContainerRequestContext)requestContext).getResourceMethod();
                    SofaResourceFactory factory = resourceMethodInvoker.getResource();
                    String serviceName = factory.getServiceName();
                    String appName = factory.getAppName();
                    if (serviceName == null) {
                        serviceName = resourceMethodInvoker.getResourceClass().getName();
                    }
                    serverSpan.setTag("service", serviceName);
                    if (resourceMethodInvoker.getMethod() != null) {
                        serverSpan.setTag("method", resourceMethodInvoker.getMethod().getName());
                        context.setAttachment(METHOD_TYPE_STRING, resourceMethodInvoker.getMethod());
                    }
                    serverSpan.setTag("remote.ip", context.getRemoteHostName());
                    String remoteAppName = requestContext.getHeaderString("app");
                    if (StringUtils.isNotBlank(remoteAppName)) {
                        serverSpan.setTag("remote.app", remoteAppName);
                    }
                    serverSpan.setTag("protocol", "rest");
                    serverSpan.setTag("invoke.type", "sync");
                    if (appName == null) {
                        appName = (String)RpcRuntimeContext.get("appName");
                    }
                    serverSpan.setTag("local.app", appName);
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("the process of rest tracer server filter occur error ", t);
            }
        }
    }

    public static void serverSend(NettyHttpResponse response, Throwable throwable) {
        block10: {
            try {
                SofaRequest sofaRequest = new SofaRequest();
                SofaResponse sofaResponse = new SofaResponse();
                if (response == null) {
                    sofaResponse.setErrorMsg("rest path ends with /favicon.ico");
                } else if (throwable != null) {
                    if (response.getStatus() == 500) {
                        sofaResponse.setAppResponse(throwable);
                    } else {
                        sofaResponse.setErrorMsg(throwable.getMessage());
                    }
                    Object method = RpcInternalContext.getContext().getAttachment(METHOD_TYPE_STRING);
                    if (method != null) {
                        Class<?>[] parameterTypes = ((Method)method).getParameterTypes();
                        String[] methodTypeString = new String[parameterTypes.length];
                        for (int i = 0; i < methodTypeString.length; ++i) {
                            methodTypeString[i] = parameterTypes[i].getName();
                        }
                        sofaRequest.setMethodArgSigs(methodTypeString);
                    }
                }
                SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
                SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
                RpcInternalContext context = RpcInternalContext.getContext();
                if (serverSpan != null) {
                    serverSpan.setTag("biz.impl.time", (Number)context.getAttachment("_impl_elapse"));
                }
                RestBaggageItemsHandler.encodeBaggageItemsToResponse(response, sofaResponse);
                Tracers.serverSend(sofaRequest, sofaResponse, null);
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block10;
                LOGGER.warn("the process of rest tracer server send occur error ", t);
            }
        }
    }

    public static void clientReceived(ClientResponseContext responseContext) {
        RestBaggageItemsHandler.decodeBaggageItemsFromResponse((MultivaluedMap<String, String>)responseContext.getHeaders());
    }

    private static class RestBaggageItemsHandler {
        private static final String RPC_REQUEST_BAGGAGE_PREFIX = "rpc_req_baggage.";
        private static final int RPC_REQUEST_BAGGAGE_PREFIX_LEN = "rpc_req_baggage.".length();
        private static final String RPC_RESPONSE_BAGGAGE_PREFIX = "rpc_resp_baggage.";
        private static final int RPC_RESPONSE_BAGGAGE_PREFIX_LEN = "rpc_resp_baggage.".length();

        private RestBaggageItemsHandler() {
        }

        private static void encodeBaggageItemToRequest(MultivaluedMap<String, Object> headers) {
            RpcInvokeContext rpcInvokeContext = RpcInvokeContext.peekContext();
            if (rpcInvokeContext == null || !RpcInvokeContext.isBaggageEnable() || rpcInvokeContext.getAllRequestBaggage() == null || rpcInvokeContext.getAllRequestBaggage().isEmpty()) {
                return;
            }
            Map<String, String> baggageItems = rpcInvokeContext.getAllRequestBaggage();
            for (Map.Entry<String, String> entry : baggageItems.entrySet()) {
                String baggageKey = RPC_REQUEST_BAGGAGE_PREFIX + entry.getKey();
                headers.putSingle((Object)baggageKey, (Object)entry.getValue());
            }
        }

        private static void decodeBaggageItemsFromRequest(NettyHttpRequest request, SofaRequest sofaRequest) {
            HttpHeaders headers = request.getHttpHeaders();
            MultivaluedMap headerMaps = headers.getRequestHeaders();
            if (!RpcInvokeContext.isBaggageEnable() || headerMaps == null || headerMaps.isEmpty()) {
                return;
            }
            HashMap<String, String> baggageItems = new HashMap<String, String>();
            for (Map.Entry entry : headerMaps.entrySet()) {
                if (!((String)entry.getKey()).startsWith(RPC_REQUEST_BAGGAGE_PREFIX) || entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                String value = (String)((List)entry.getValue()).get(0);
                String key = ((String)entry.getKey()).substring(RPC_REQUEST_BAGGAGE_PREFIX_LEN);
                baggageItems.put(key, value);
            }
            sofaRequest.addRequestProp("rpc_req_baggage", baggageItems);
            BaggageResolver.pickupFromRequest(RpcInvokeContext.peekContext(), sofaRequest, true);
        }

        private static void encodeBaggageItemsToResponse(NettyHttpResponse response, SofaResponse sofaResponse) {
            RpcInvokeContext context = RpcInvokeContext.peekContext();
            if (response == null || context == null || context.getAllResponseBaggage() == null || context.getAllResponseBaggage().isEmpty()) {
                return;
            }
            for (Map.Entry<String, String> entry : context.getAllResponseBaggage().entrySet()) {
                String key = RPC_RESPONSE_BAGGAGE_PREFIX + entry.getKey();
                String value = entry.getValue();
                response.getOutputHeaders().add((Object)key, (Object)value);
            }
            BaggageResolver.carryWithResponse(context, sofaResponse);
        }

        private static void decodeBaggageItemsFromResponse(MultivaluedMap<String, String> headers) {
            if (!RpcInvokeContext.isBaggageEnable() || headers == null || headers.isEmpty()) {
                return;
            }
            LinkedHashMap<String, String> baggageItems = new LinkedHashMap<String, String>();
            for (Map.Entry entry : headers.entrySet()) {
                if (!((String)entry.getKey()).startsWith(RPC_RESPONSE_BAGGAGE_PREFIX) || entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                String key = ((String)entry.getKey()).substring(RPC_RESPONSE_BAGGAGE_PREFIX_LEN);
                String value = (String)((List)entry.getValue()).get(0);
                baggageItems.put(key, value);
            }
            RpcInvokeContext.getContext().putAllResponseBaggage(baggageItems);
        }
    }
}

