/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.client;

import com.alibaba.cloudapi.sdk.client.BaseApiClient;
import com.alibaba.cloudapi.sdk.constant.SdkConstant;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.enums.WebSocketApiType;
import com.alibaba.cloudapi.sdk.enums.WebSocketConnectStatus;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiContext;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.ApiWebSocketListner;
import com.alibaba.cloudapi.sdk.model.WebSocketApiRequest;
import com.alibaba.cloudapi.sdk.model.WebSocketClientBuilderParams;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.CallbackManager;
import com.alibaba.cloudapi.sdk.util.HeartBeatManager;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.alibaba.cloudapi.sdk.util.ObjectReference;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.codec.binary.Base64;

public class WebSocketApiClient
extends BaseApiClient {
    final ObjectReference<WebSocket> webSocketRef = new ObjectReference();
    final ObjectReference<CountDownLatch> connectLatch = new ObjectReference();
    final ObjectReference<CountDownLatch> registerLatch = new ObjectReference();
    final ObjectReference<Boolean> registerCommandSuccess = new ObjectReference();
    final ObjectReference<String> errorMessage = new ObjectReference();
    private WebSocketApiClient instance;
    String websocketUrl;
    OkHttpClient client;
    Request connectRequest;
    ApiWebSocketListner apiWebSocketListner;
    AtomicInteger seq = new AtomicInteger(0);
    CallbackManager callbackManager;
    Thread callbackThread;
    WebSocketConnectStatus status = WebSocketConnectStatus.LOST_CONNECTION;
    WebSocketListener webSocketListener;
    HeartBeatManager heartBeatManager;
    Thread heartbeatThread;
    final int port = 8080;
    String deviceId;
    String connectionCredential = "";
    ApiRequest lastRegisterReqeust;
    ApiCallback lastRegisterCallback;
    boolean isRegister = false;
    int heartBeatInterval = 25000;
    Object connectionLock = new Object();

    protected String getDeviceId() {
        return this.deviceId;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    public boolean isOnline() {
        return this.isRegister && this.status == WebSocketConnectStatus.CONNECTED;
    }

    protected WebSocketApiClient() {
    }

    protected void init(WebSocketClientBuilderParams params) {
        if (null == params) {
            throw new SdkException("WebSocketClientBuilderParams must not be null");
        }
        params.check();
        this.appKey = params.getAppKey();
        this.appSecret = params.getAppSecret();
        this.deviceId = this.generateDeviceSum();
        this.websocketUrl = Scheme.WEBSOCKET.getValue() + params.getHost();
        this.websocketUrl = this.websocketUrl + ":" + 8080;
        this.host = params.getHost();
        this.scheme = Scheme.WEBSOCKET;
        this.client = new OkHttpClient.Builder().readTimeout(params.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(params.getWriteTimeout(), TimeUnit.MILLISECONDS).connectTimeout(params.getConnectionTimeout(), TimeUnit.MILLISECONDS).build();
        this.connectRequest = new Request.Builder().url(this.websocketUrl).build();
        this.apiWebSocketListner = params.getApiWebSocketListner();
        this.callbackManager = new CallbackManager(params.getCallbackThreadPoolCount(), params.getRequestExpiredTime());
        this.callbackThread = new Thread(this.callbackManager);
        this.callbackThread.start();
        this.connect();
        this.registerCommandSuccess.setObj(false);
        this.errorMessage.setObj("");
        this.instance = this;
        this.isInit = true;
    }

    public WebSocketConnectStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebSocketConnectStatus status) {
        this.status = status;
    }

    public void connect() {
        if (null == this.connectLatch.getObj()) {
            this.connectLatch.setObj(new CountDownLatch(1));
        }
        if (null == this.webSocketListener) {
            this.webSocketListener = new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    WebSocketApiClient.this.webSocketRef.setObj(webSocket);
                    WebSocketApiClient.this.status = WebSocketConnectStatus.CONNECTED;
                    WebSocketApiClient.this.registerLatch.setObj(new CountDownLatch(1));
                    String registerCommand = "RG#" + WebSocketApiClient.this.deviceId;
                    WebSocketApiClient.this.webSocketRef.getObj().send(registerCommand);
                    if (null != WebSocketApiClient.this.connectLatch.getObj()) {
                        WebSocketApiClient.this.connectLatch.getObj().countDown();
                    }
                }

                public void onMessage(WebSocket webSocket, String text) {
                    if (null == text || "".equalsIgnoreCase(text)) {
                        return;
                    }
                    if (text.length() > 2 && text.startsWith("HO")) {
                        if (!WebSocketApiClient.this.connectionCredential.equalsIgnoreCase(text.substring(3))) {
                            WebSocketApiClient.this.reSendRegister();
                        }
                        return;
                    }
                    if ("OS".equalsIgnoreCase(text)) {
                        WebSocketApiClient.this.close();
                        return;
                    }
                    if ("CR".equalsIgnoreCase(text)) {
                        WebSocketApiClient.this.close();
                        return;
                    }
                    if (text.length() > 2 && text.startsWith("RF")) {
                        WebSocketApiClient.this.registerCommandSuccess.setObj(false);
                        String[] responseObject = text.split("#");
                        WebSocketApiClient.this.errorMessage.setObj(responseObject[1]);
                        if (null != WebSocketApiClient.this.registerLatch.getObj()) {
                            WebSocketApiClient.this.registerLatch.getObj().countDown();
                        }
                        if (null != WebSocketApiClient.this.heartBeatManager) {
                            WebSocketApiClient.this.heartBeatManager.stop();
                        }
                        return;
                    }
                    if (text.length() > 2 && text.startsWith("RO")) {
                        WebSocketApiClient.this.registerCommandSuccess.setObj(true);
                        String[] responseObject = text.split("#");
                        WebSocketApiClient.this.connectionCredential = responseObject[1];
                        WebSocketApiClient.this.heartBeatInterval = Integer.parseInt(responseObject[2]);
                        if (null != WebSocketApiClient.this.registerLatch.getObj()) {
                            WebSocketApiClient.this.registerLatch.getObj().countDown();
                        }
                        if (null != WebSocketApiClient.this.heartBeatManager) {
                            WebSocketApiClient.this.heartBeatManager.stop();
                        }
                        WebSocketApiClient.this.heartBeatManager = new HeartBeatManager(WebSocketApiClient.this.instance, WebSocketApiClient.this.heartBeatInterval);
                        WebSocketApiClient.this.heartbeatThread = new Thread(WebSocketApiClient.this.heartBeatManager);
                        WebSocketApiClient.this.heartbeatThread.start();
                        if (WebSocketApiClient.this.isRegister) {
                            WebSocketApiClient.this.reSendRegister();
                        }
                        return;
                    }
                    if (text.length() > 2 && text.startsWith("NF")) {
                        String message = text.substring(3);
                        WebSocketApiClient.this.apiWebSocketListner.onNotify(message);
                        if (WebSocketApiClient.this.status == WebSocketConnectStatus.CONNECTED && WebSocketApiClient.this.webSocketRef.getObj() != null) {
                            WebSocketApiClient.this.webSocketRef.getObj().send("NO");
                        }
                        return;
                    }
                    if (text.length() > 2 && !text.startsWith("{") && "#".equalsIgnoreCase(text.substring(3, 4))) {
                        return;
                    }
                    try {
                        JSONObject receivedObject = JSON.parseObject((String)text);
                        ApiResponse response = new ApiResponse(receivedObject);
                        String seqStr = response.getFirstHeaderValue("x-ca-seq");
                        Integer seq = Integer.parseInt(seqStr);
                        ApiContext context = WebSocketApiClient.this.callbackManager.getContext(seq);
                        WebSocketApiType type = context.getRequest().getWebSocketApiType();
                        if (null != context && type != WebSocketApiType.COMMON) {
                            WebSocketApiClient.this.postSendWebsocketCommandApi(type, response);
                        }
                        WebSocketApiClient.this.callbackManager.callback(seq, response);
                    }
                    catch (Exception ex) {
                        WebSocketApiClient.this.apiWebSocketListner.onFailure(ex, new ApiResponse(508, "Call back occue error", ex));
                    }
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    WebSocketApiClient.this.webSocketRef.setObj(null);
                    WebSocketApiClient.this.reconnect();
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    block11: {
                        try {
                            ApiResponse apiResponse;
                            if (null != response) {
                                apiResponse = new ApiResponse(response.code());
                                apiResponse.setMessage(response.message());
                            } else {
                                apiResponse = new ApiResponse(505);
                                apiResponse.setMessage("WebSocket inner failed");
                            }
                            apiResponse.setEx(new SdkException(t));
                            WebSocketApiClient.this.apiWebSocketListner.onFailure(t, apiResponse);
                            if (null == t) break block11;
                            if (t instanceof ConnectException || t instanceof SocketTimeoutException || t instanceof UnknownHostException) {
                                if (null != WebSocketApiClient.this.connectLatch.getObj()) {
                                    WebSocketApiClient.this.connectLatch.getObj().countDown();
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                WebSocketApiClient.this.reconnect();
                                break block11;
                            }
                            if (!(t instanceof SocketException) && !(t instanceof EOFException)) break block11;
                            if (null == WebSocketApiClient.this.connectLatch.getObj()) {
                                WebSocketApiClient.this.connectLatch.setObj(new CountDownLatch(1));
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            WebSocketApiClient.this.reconnect();
                        }
                        catch (Exception ex) {
                            WebSocketApiClient.this.apiWebSocketListner.onFailure(ex, new ApiResponse(507, "Failure block", ex));
                        }
                    }
                }
            };
        }
        this.client.newWebSocket(this.connectRequest, this.webSocketListener);
    }

    private void reSendRegister() {
        this.sendAsyncRequest(this.lastRegisterReqeust, this.lastRegisterCallback);
    }

    private void reconnect() {
        this.status = WebSocketConnectStatus.LOST_CONNECTION;
        if (null != this.heartBeatManager) {
            this.heartBeatManager.stop();
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.connectLatch.setObj(new CountDownLatch(1));
                if (null != this.heartBeatManager) {
                    this.heartBeatManager.stop();
                }
                if (null != this.webSocketRef.getObj()) {
                    Thread.sleep(1000L);
                    this.webSocketRef.getObj().close(1000, "Reconnect");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected ApiResponse sendSyncRequest(ApiRequest apiRequest) {
        throw new SdkException("Not support sending sync request via websocket channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendAsyncRequest(ApiRequest apiRequest, ApiCallback apiCallback) {
        this.checkIsInit();
        Object object = this.connectionLock;
        synchronized (object) {
            if (null != this.connectLatch.getObj() && this.connectLatch.getObj().getCount() == 1L) {
                try {
                    this.connectLatch.getObj().await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    throw new SdkException("WebSocket connect server failed ", ex);
                }
                finally {
                    this.connectLatch.setObj(null);
                }
            }
            if (this.status == WebSocketConnectStatus.LOST_CONNECTION) {
                apiCallback.onFailure(apiRequest, new SdkException("WebSocket conection lost , connecting"));
                return;
            }
            if (WebSocketApiType.COMMON != apiRequest.getWebSocketApiType() && !this.preSendWebsocketCommandApi(apiRequest, apiCallback)) {
                return;
            }
            Integer seqNumber = this.seq.getAndIncrement();
            apiRequest.addHeader("x-ca-seq", seqNumber.toString());
            this.callbackManager.add(seqNumber, new ApiContext(apiCallback, apiRequest));
            String request = this.buildRequest(apiRequest);
            this.webSocketRef.getObj().send(request);
        }
    }

    private boolean preSendWebsocketCommandApi(ApiRequest apiRequest, ApiCallback apiCallback) {
        if (WebSocketApiType.REGISTER == apiRequest.getWebSocketApiType()) {
            try {
                if (null != this.registerLatch.getObj() && !this.registerLatch.getObj().await(10L, TimeUnit.SECONDS)) {
                    Thread.sleep(5000L);
                    this.close();
                    apiCallback.onFailure(apiRequest, new SdkException("WebSocket conection lost , connecting"));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException ex) {
                throw new SdkException("WebSocket register failed ", ex);
            }
            finally {
                this.registerLatch.setObj(null);
            }
            if (!this.registerCommandSuccess.getObj().booleanValue()) {
                apiCallback.onFailure(null, new SdkException("Register Comand return error :" + this.errorMessage.getObj()));
                return false;
            }
            this.lastRegisterReqeust = apiRequest.duplicate();
            this.lastRegisterCallback = apiCallback;
        }
        apiRequest.addHeader("x-ca-websocket_api_type", apiRequest.getWebSocketApiType().toString());
        return true;
    }

    private void postSendWebsocketCommandApi(WebSocketApiType type, ApiResponse response) {
        if (WebSocketApiType.REGISTER == type && 200 == response.getCode()) {
            this.isRegister = true;
        }
        if (WebSocketApiType.UNREGISTER == type) {
            if (null != this.heartBeatManager) {
                this.heartBeatManager.stop();
            }
            this.lastRegisterReqeust = null;
            this.lastRegisterCallback = null;
            this.isRegister = false;
        }
    }

    public void sendHeatbeart() {
        if (this.isInit && this.status == WebSocketConnectStatus.CONNECTED && this.webSocketRef.getObj() != null) {
            this.webSocketRef.getObj().send("H1");
        }
    }

    private String generateDeviceSum() {
        return this.generateDeviceId() + "@" + this.appKey;
    }

    private String generateDeviceId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    private String buildRequest(ApiRequest apiRequest) {
        apiRequest.setHost(this.host);
        apiRequest.setScheme(this.scheme);
        ApiRequestMaker.make(apiRequest, this.appKey, this.appSecret);
        WebSocketApiRequest webSocketApiRequest = new WebSocketApiRequest();
        webSocketApiRequest.setHost(this.host);
        webSocketApiRequest.setPath(apiRequest.getPath());
        webSocketApiRequest.setMethod(apiRequest.getMethod().getValue());
        webSocketApiRequest.setQuerys(apiRequest.getQuerys());
        webSocketApiRequest.setHeaders(apiRequest.getHeaders());
        webSocketApiRequest.setIsBase64(apiRequest.isBase64BodyViaWebsocket() ? 1 : 0);
        MediaType bodyType = MediaType.parse((String)apiRequest.getFirstHeaderValue("content-type"));
        if (null != apiRequest.getFormParams() && apiRequest.getFormParams().size() > 0) {
            webSocketApiRequest.setBody(HttpCommonUtil.buildParamString(apiRequest.getFormParams()));
        } else if (null != apiRequest.getBody()) {
            webSocketApiRequest.setBody(new String(apiRequest.getBody(), bodyType.charset(SdkConstant.CLOUDAPI_ENCODING)));
        }
        if (apiRequest.isBase64BodyViaWebsocket()) {
            webSocketApiRequest.setBody(Base64.encodeBase64String((byte[])apiRequest.getBody()));
        }
        return JSON.toJSONString((Object)webSocketApiRequest);
    }
}

