/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.signature;

import com.alibaba.cloudapi.sdk.signature.HMacSHA1SignerFactory;
import com.alibaba.cloudapi.sdk.signature.HMacSHA256SignerFactory;
import com.alibaba.cloudapi.sdk.signature.ISignerFactory;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import java.util.HashMap;
import java.util.Map;

public class SignerFactoryManager {
    private static Map<String, ISignerFactory> factoryMap = new HashMap<String, ISignerFactory>(2);

    public static ISignerFactory registerSignerFactory(String method, ISignerFactory factory) {
        if (HttpCommonUtil.isEmpty(method)) {
            throw new IllegalArgumentException("method can not be empty");
        }
        if (null == factory) {
            throw new IllegalArgumentException("factory can not be null");
        }
        return factoryMap.put(method, factory);
    }

    public static ISignerFactory findSignerFactory(String method) {
        if (HttpCommonUtil.isBlank(method)) {
            method = "HmacSHA256";
        }
        return factoryMap.get(method);
    }

    static {
        SignerFactoryManager.registerSignerFactory("HmacSHA256", new HMacSHA256SignerFactory());
        SignerFactoryManager.registerSignerFactory("HmacSHA1", new HMacSHA1SignerFactory());
    }
}

