/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.producer.inner;

import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.inner.NamedThreadFactory;
import com.aliyun.openservices.log.producer.inner.PackageManager;
import com.aliyun.openservices.log.producer.inner.ShardHashManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlThreadPool.class);
    private static final String CONTROL_WORKER_BASE_NAME = "log-producer-control-worker-";
    private ShardHashManager shardHashManager;
    private PackageManager packageManager;
    private ProducerConfig producerConfig;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, new NamedThreadFactory("log-producer-control-worker-"));

    public static ControlThreadPool launch(ShardHashManager shardHashManager, PackageManager packageManager, ProducerConfig producerConfig) {
        ControlThreadPool pool = new ControlThreadPool(shardHashManager, packageManager, producerConfig);
        pool.scheduleFilterTimeoutPackageTask();
        pool.scheduleFilterExpiredTask();
        return pool;
    }

    private ControlThreadPool(ShardHashManager shardHashManager, PackageManager packageManager, ProducerConfig producerConfig) {
        this.shardHashManager = shardHashManager;
        this.packageManager = packageManager;
        this.producerConfig = producerConfig;
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public void shutdownNow() {
        this.scheduledExecutorService.shutdownNow();
    }

    private void scheduleFilterTimeoutPackageTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Begin to filter timeout package.");
                    ControlThreadPool.this.packageManager.filterTimeoutPackage();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to filter timeout package.", (Throwable)e);
                }
            }
        }, 0L, this.producerConfig.packageTimeoutInMS / 2, TimeUnit.MILLISECONDS);
    }

    private void scheduleFilterExpiredTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Begin to filter expired.");
                    ControlThreadPool.this.shardHashManager.filterExpired();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to filter expired.", (Throwable)e);
                }
            }
        }, 0L, this.producerConfig.shardHashUpdateIntervalInMS * 2, TimeUnit.MILLISECONDS);
    }
}

