/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.common.domain.ContentType;
import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.JobConfigInfo;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.UpdateJobResponse;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class UpdateJobRequest
extends BaseRequest<UpdateJobResponse> {
    private JobConfigInfo jobConfigInfo;

    public JobConfigInfo getJobConfigInfo() {
        return this.jobConfigInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJobConfigInfo(JobConfigInfo jobConfigInfo) {
        this.jobConfigInfo = jobConfigInfo;
        ParamValidate.doValidator(jobConfigInfo);
        this.getParameterMap().put("jobId", jobConfigInfo.getJobId());
        this.getParameterMap().put("name", jobConfigInfo.getName());
        this.getParameterMap().put("description", jobConfigInfo.getDescription());
        this.getParameterMap().put("executeMode", jobConfigInfo.getExecuteMode());
        this.getParameterMap().put("jobType", jobConfigInfo.getJobType());
        if (jobConfigInfo.getJobType().equals("java")) {
            this.getParameterMap().put("contentType", ContentType.TEXT.getValue());
            JSONObject content = new JSONObject();
            if (!StringUtils.isNotBlank(jobConfigInfo.getClassName())) throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "className can not be blank for java");
            content.put("className", (Object)jobConfigInfo.getClassName());
            if (StringUtils.isNotBlank(jobConfigInfo.getJarUrl())) {
                content.put("jarUrl", (Object)jobConfigInfo.getJarUrl());
            }
            this.getParameterMap().put("content", content.toJSONString());
        } else {
            this.getParameterMap().put("contentType", ContentType.SCRIPT.getValue());
            this.getParameterMap().put("content", jobConfigInfo.getContent());
        }
        this.getParameterMap().put("description", jobConfigInfo.getDescription());
        this.getParameterMap().put("parameters", jobConfigInfo.getParameters());
        this.getParameterMap().put("maxConcurrency", jobConfigInfo.getMaxConcurrency());
        this.getParameterMap().put("maxAttempt", jobConfigInfo.getMaxAttempt());
        this.getParameterMap().put("attemptInterval", jobConfigInfo.getAttemptInterval());
        this.getParameterMap().put("status", jobConfigInfo.getStatus());
        if (jobConfigInfo.getMapTaskXAttrs() != null) {
            this.getParameterMap().put("xattrs", JSON.toJSONString((Object)jobConfigInfo.getMapTaskXAttrs()));
        }
        if (jobConfigInfo.getTimeConfig() == null) {
            throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "TimeConfig can not be blank");
        }
        this.getParameterMap().put("timeType", jobConfigInfo.getTimeConfig().getTimeType());
        this.getParameterMap().put("timeExpression", jobConfigInfo.getTimeConfig().getTimeExpression());
        this.getParameterMap().put("calendar", jobConfigInfo.getTimeConfig().getCalendar());
        this.getParameterMap().put("dataOffset", jobConfigInfo.getTimeConfig().getDataOffset());
        this.getParameterMap().put("timezone", jobConfigInfo.getTimeConfig().getTimezone());
        if (jobConfigInfo.getJobMonitorInfo() == null) {
            throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "JobMonitorInfo can not be blank");
        }
        this.getParameterMap().put("monitorConfig", JSON.toJSONString((Object)jobConfigInfo.getJobMonitorInfo().getMonitorConfig()));
        this.getParameterMap().put("contact", JSON.toJSONString(jobConfigInfo.getJobMonitorInfo().getContactInfo()));
    }

    @Override
    public Class<UpdateJobResponse> getResponseClass() {
        return UpdateJobResponse.class;
    }

    @Override
    public String getUrlPath() {
        return "/openapi/v1/job/update";
    }
}

