/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.common.util.IpUtil;
import com.alibaba.schedulerx.shade.com.google.common.base.Throwables;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.PropertiesConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.HashMap;
import java.util.Iterator;

public class ConfigUtil {
    private static PropertiesConfiguration workerConfig = null;
    private static PropertiesConfiguration serverConfig = null;

    public static synchronized Configuration getServerConfig() {
        if (serverConfig == null) {
            serverConfig = ConfigUtil.getPropertiesConfig("server.properties");
        }
        return serverConfig;
    }

    public static synchronized Configuration getWorkerConfig() {
        if (workerConfig == null) {
            workerConfig = ConfigUtil.getPropertiesConfig("schedulerx-worker.properties");
        }
        return workerConfig;
    }

    public static Configuration newConfig(String fileName) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(fileName);
            return config;
        }
        catch (Throwable e) {
            Throwables.propagate(e);
            return null;
        }
    }

    private static PropertiesConfiguration getPropertiesConfig(String fileName) {
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(fileName);
            config.setReloadingStrategy(new FileChangedReloadingStrategy());
        }
        catch (Throwable e) {
            Throwables.propagate(e);
        }
        return config;
    }

    public static Config getAkkaConfig(String fileName) {
        return ConfigUtil.getAkkaConfig(fileName, null);
    }

    public static Config getAkkaConfig(String fileName, String host) {
        String key = "akka.remote.netty.tcp.hostname";
        Config akkaConfig = ConfigFactory.load(fileName);
        if (host != null) {
            return ConfigFactory.parseString(key + "=" + host).withFallback(akkaConfig);
        }
        if (akkaConfig.hasPath(key) && !akkaConfig.getString(key).isEmpty()) {
            return akkaConfig;
        }
        return ConfigFactory.parseString(key + "=" + IpUtil.getIPV4Address()).withFallback(akkaConfig);
    }

    public static Config getAkkaConfig(String fileName, String host, int port) {
        String hostKey = "akka.remote.netty.tcp.hostname";
        String portKey = "akka.remote.netty.tcp.port";
        Config akkaConfig = ConfigFactory.load(fileName);
        if (host != null) {
            HashMap<String, Object> paraMap = Maps.newHashMap();
            paraMap.put(hostKey, host);
            paraMap.put(portKey, port);
            return ConfigFactory.parseMap(paraMap).withFallback(akkaConfig);
        }
        if (akkaConfig.hasPath(hostKey) && !akkaConfig.getString(hostKey).isEmpty()) {
            return akkaConfig;
        }
        return ConfigFactory.parseString(hostKey + "=" + IpUtil.getIPV4Address()).withFallback(akkaConfig);
    }

    public static Config getAkkaConfig(String fileName, String externalHostname, String externalPort, String bindHostname) {
        String hostKey = "akka.remote.netty.tcp.bind-hostname";
        HashMap<String, String> map2 = Maps.newHashMap();
        if (externalHostname != null) {
            map2.put("akka.remote.netty.tcp.hostname", externalHostname);
        }
        if (externalPort != null) {
            map2.put("akka.remote.netty.tcp.port", externalPort);
        }
        if (bindHostname != null) {
            map2.put("akka.remote.netty.tcp.bind-hostname", bindHostname);
        }
        Config akkaConfig = ConfigFactory.load(fileName);
        if (!map2.isEmpty()) {
            return ConfigFactory.parseMap(map2).withFallback(akkaConfig);
        }
        if (akkaConfig.hasPath(hostKey) && !akkaConfig.getString(hostKey).isEmpty()) {
            return akkaConfig;
        }
        return ConfigFactory.parseString(hostKey + "=" + IpUtil.getIPV4Address()).withFallback(akkaConfig);
    }

    public static String toString(Configuration conf) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<String> it = conf.getKeys();
        boolean firstKey = true;
        while (it.hasNext()) {
            String key = it.next();
            if (key.trim().isEmpty()) continue;
            String value2 = conf.getProperty(key).toString();
            if (!firstKey) {
                sb.append(", ");
            } else {
                firstKey = false;
            }
            sb.append(key + "=" + value2);
        }
        sb.append("]");
        return sb.toString();
    }
}

