/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.utils;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientException;
import com.alibaba.schedulerx.shade.org.apache.http.NoHttpResponseException;
import com.alibaba.schedulerx.shade.org.apache.http.client.ClientProtocolException;
import com.alibaba.schedulerx.shade.org.apache.http.client.NonRepeatableRequestException;
import com.alibaba.schedulerx.shade.org.apache.http.conn.ConnectTimeoutException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonRepeatableRequestException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }
}

