/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.graph;

import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.collect.AbstractIterator;
import com.alibaba.schedulerx.shade.com.google.common.collect.ImmutableMap;
import com.alibaba.schedulerx.shade.com.google.common.collect.UnmodifiableIterator;
import com.alibaba.schedulerx.shade.com.google.common.graph.GraphConnections;
import com.alibaba.schedulerx.shade.com.google.common.graph.Graphs;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> adjacentNodeValues, int predecessorCount, int successorCount) {
        this.adjacentNodeValues = Preconditions.checkNotNull(adjacentNodeValues);
        this.predecessorCount = Graphs.checkNonNegative(predecessorCount);
        this.successorCount = Graphs.checkNonNegative(successorCount);
        Preconditions.checkState(predecessorCount <= adjacentNodeValues.size() && successorCount <= adjacentNodeValues.size());
    }

    static <N, V> DirectedGraphConnections<N, V> of() {
        int initialCapacity = 4;
        return new DirectedGraphConnections(new HashMap(initialCapacity, 1.0f), 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(Set<N> predecessors, Map<N, V> successorValues) {
        HashMap<N, Object> adjacentNodeValues = new HashMap<N, Object>();
        adjacentNodeValues.putAll(successorValues);
        for (N predecessor : predecessors) {
            Object value2 = adjacentNodeValues.put(predecessor, PRED);
            if (value2 == null) continue;
            adjacentNodeValues.put(predecessor, new PredAndSucc(value2));
        }
        return new DirectedGraphConnections(ImmutableMap.copyOf(adjacentNodeValues), predecessors.size(), successorValues.size());
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator entries = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                return new AbstractIterator<N>(){

                    @Override
                    protected N computeNext() {
                        while (entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)entries.next();
                            if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }

            @Override
            public boolean contains(@Nullable Object obj) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj));
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator entries = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                return new AbstractIterator<N>(){

                    @Override
                    protected N computeNext() {
                        while (entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)entries.next();
                            if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }

            @Override
            public boolean contains(@Nullable Object obj) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj));
            }
        };
    }

    @Override
    public V value(Object node) {
        Object value2 = this.adjacentNodeValues.get(node);
        if (value2 == PRED) {
            return null;
        }
        if (value2 instanceof PredAndSucc) {
            return (V)((PredAndSucc)value2).successorValue;
        }
        return (V)value2;
    }

    @Override
    public void removePredecessor(Object node) {
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == PRED) {
            this.adjacentNodeValues.remove(node);
            Graphs.checkNonNegative(--this.predecessorCount);
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, ((PredAndSucc)previousValue).successorValue);
            Graphs.checkNonNegative(--this.predecessorCount);
        }
    }

    @Override
    public V removeSuccessor(Object node) {
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == null || previousValue == PRED) {
            return null;
        }
        if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, PRED);
            Graphs.checkNonNegative(--this.successorCount);
            return (V)((PredAndSucc)previousValue).successorValue;
        }
        this.adjacentNodeValues.remove(node);
        Graphs.checkNonNegative(--this.successorCount);
        return (V)previousValue;
    }

    @Override
    public void addPredecessor(N node, V unused) {
        Object previousValue = this.adjacentNodeValues.put(node, PRED);
        if (previousValue == null) {
            Graphs.checkPositive(++this.predecessorCount);
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, previousValue);
        } else if (previousValue != PRED) {
            this.adjacentNodeValues.put(node, new PredAndSucc(previousValue));
            Graphs.checkPositive(++this.predecessorCount);
        }
    }

    @Override
    public V addSuccessor(N node, V value2) {
        Object previousValue = this.adjacentNodeValues.put(node, value2);
        if (previousValue == null) {
            Graphs.checkPositive(++this.successorCount);
            return null;
        }
        if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, new PredAndSucc(value2));
            return (V)((PredAndSucc)previousValue).successorValue;
        }
        if (previousValue == PRED) {
            this.adjacentNodeValues.put(node, new PredAndSucc(value2));
            Graphs.checkPositive(++this.successorCount);
            return null;
        }
        return (V)previousValue;
    }

    private static boolean isPredecessor(@Nullable Object value2) {
        return value2 == PRED || value2 instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@Nullable Object value2) {
        return value2 != PRED && value2 != null;
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        PredAndSucc(Object successorValue) {
            this.successorValue = successorValue;
        }
    }
}

