/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.mashape.unirest.http.utils;

import com.alibaba.schedulerx.shade.org.apache.http.Header;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseUtils {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size2 = 1024;
        if (is instanceof ByteArrayInputStream) {
            size2 = is.available();
            buf = new byte[size2];
            int len2 = is.read(buf, 0, size2);
        } else {
            int len3;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size2];
            while ((len3 = is.read(buf, 0, size2)) != -1) {
                bos.write(buf, 0, len3);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    public static boolean isGzipped(Header contentEncoding) {
        String value2;
        return contentEncoding != null && (value2 = contentEncoding.getValue()) != null && "gzip".equals(value2.toLowerCase().trim());
    }
}

