/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.burlap.server;

import com.alibaba.schedulerx.shade.hsf.burlap.io.BurlapInput;
import com.alibaba.schedulerx.shade.hsf.burlap.io.BurlapOutput;
import com.alibaba.schedulerx.shade.hsf.services.server.AbstractSkeleton;
import com.alibaba.schedulerx.shade.hsf.services.server.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BurlapSkeleton
extends AbstractSkeleton {
    private static final Logger log = Logger.getLogger(BurlapSkeleton.class.getName());
    private Object _service;

    public BurlapSkeleton(Object service, Class apiClass) {
        super(apiClass);
        this._service = service;
    }

    public BurlapSkeleton(Class apiClass) {
        super(apiClass);
    }

    public void invoke(BurlapInput in2, BurlapOutput out) throws Exception {
        this.invoke(this._service, in2, out);
    }

    public void invoke(Object service, BurlapInput in2, BurlapOutput out) throws Exception {
        String header;
        in2.readCall();
        ServiceContext context = ServiceContext.getContext();
        while ((header = in2.readHeader()) != null) {
            Object value2 = in2.readObject();
            context.addHeader(header, value2);
        }
        String methodName = in2.readMethod();
        Method method = this.getMethod(methodName);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invoking " + methodName + " (" + method + ")");
        }
        if (method == null) {
            if ("_burlap_getAttribute".equals(in2.getMethod())) {
                String attrName = in2.readString();
                in2.completeCall();
                String value3 = null;
                if ("java.api.class".equals(attrName)) {
                    value3 = this.getAPIClassName();
                } else if ("java.home.class".equals(attrName)) {
                    value3 = this.getHomeClassName();
                } else if ("java.object.class".equals(attrName)) {
                    value3 = this.getObjectClassName();
                }
                out.startReply();
                out.writeObject(value3);
                out.completeReply();
                return;
            }
            if (method == null) {
                out.startReply();
                out.writeFault("NoSuchMethodException", "The service has no method named: " + in2.getMethod(), null);
                out.completeReply();
                return;
            }
        }
        Class<?>[] args = method.getParameterTypes();
        Object[] values2 = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values2[i] = in2.readObject(args[i]);
        }
        in2.completeCall();
        Object result2 = null;
        try {
            result2 = method.invoke(service, values2);
        }
        catch (Throwable e) {
            log.log(Level.FINE, service + "." + method.getName() + "() failed with exception:\n" + e.toString(), e);
            if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
            return;
        }
        out.startReply();
        out.writeObject(result2);
        out.completeReply();
    }
}

