/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json;

import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.util.JSONUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.builder.EqualsBuilder;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;

public class JSONFunction
implements Serializable {
    private static final String[] EMPTY_PARAM_ARRAY = new String[0];
    private String[] params;
    private String text;

    public static JSONFunction parse(String str) {
        if (!JSONUtils.isFunction(str)) {
            throw new JSONException("String is not a function. " + str);
        }
        String params = JSONUtils.getFunctionParams(str);
        String text = JSONUtils.getFunctionBody(str);
        return new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text != null ? text : "");
    }

    public JSONFunction(String text) {
        this(null, text);
    }

    public JSONFunction(String[] params, String text) {
        String string2 = this.text = text != null ? text.trim() : "";
        if (params != null) {
            if (params.length == 1 && params[0].trim().equals("")) {
                this.params = EMPTY_PARAM_ARRAY;
            } else {
                this.params = new String[params.length];
                System.arraycopy(params, 0, this.params, 0, params.length);
                for (int i = 0; i < params.length; ++i) {
                    this.params[i] = this.params[i].trim();
                }
            }
        } else {
            this.params = EMPTY_PARAM_ARRAY;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            try {
                JSONFunction other = JSONFunction.parse((String)obj);
                return this.equals(other);
            }
            catch (JSONException e) {
                return false;
            }
        }
        if (!(obj instanceof JSONFunction)) {
            return false;
        }
        JSONFunction other = (JSONFunction)obj;
        if (this.params.length != other.params.length) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        for (int i = 0; i < this.params.length; ++i) {
            builder.append(this.params[i], other.params[i]);
        }
        builder.append(this.text, other.text);
        return builder.isEquals();
    }

    public String[] getParams() {
        return this.params;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (int i = 0; i < this.params.length; ++i) {
            builder.append(this.params[i]);
        }
        builder.append(this.text);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("function(");
        if (this.params.length > 0) {
            for (int i = 0; i < this.params.length - 1; ++i) {
                b.append(this.params[i]).append(',');
            }
            b.append(this.params[this.params.length - 1]);
        }
        b.append("){");
        if (this.text.length() > 0) {
            b.append(' ').append(this.text).append(' ');
        }
        b.append('}');
        return b.toString();
    }
}

