/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json.util;

import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JsonConfig;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class PropertySetStrategy {
    public static final PropertySetStrategy DEFAULT = new DefaultPropertySetStrategy();

    public abstract void setProperty(Object var1, String var2, Object var3) throws JSONException;

    public void setProperty(Object bean, String key, Object value2, JsonConfig jsonConfig) throws JSONException {
        this.setProperty(bean, key, value2);
    }

    private static final class DefaultPropertySetStrategy
    extends PropertySetStrategy {
        private DefaultPropertySetStrategy() {
        }

        public void setProperty(Object bean, String key, Object value2) throws JSONException {
            this.setProperty(bean, key, value2, new JsonConfig());
        }

        public void setProperty(Object bean, String key, Object value2, JsonConfig jsonConfig) throws JSONException {
            if (bean instanceof Map) {
                ((Map)bean).put(key, value2);
            } else if (!jsonConfig.isIgnorePublicFields()) {
                try {
                    Field field2 = bean.getClass().getField(key);
                    if (field2 != null) {
                        field2.set(bean, value2);
                    }
                }
                catch (Exception e) {
                    this._setProperty(bean, key, value2);
                }
            } else {
                this._setProperty(bean, key, value2);
            }
        }

        private void _setProperty(Object bean, String key, Object value2) {
            try {
                PropertyUtils.setSimpleProperty(bean, key, value2);
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
    }
}

