/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.logging;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.NoOpLog;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    public static void setLogImplementation(String classname) throws LinkageError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> logclass = Class.forName(classname);
            Class[] argtypes = new Class[]{"".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable t) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static Log getInstance(String name) {
        Log log2 = (Log)logs.get(name);
        if (null == log2) {
            log2 = LogSource.makeNewLogInstance(name);
            logs.put(name, log2);
        }
        return log2;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name) {
        Log log2;
        try {
            Object[] args = new Object[]{name};
            log2 = (Log)logImplctor.newInstance(args);
        }
        catch (Throwable t) {
            log2 = null;
        }
        if (null == log2) {
            log2 = new NoOpLog(name);
        }
        return log2;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    static {
        try {
            log4jIsAvailable = null != Class.forName("org.apache.log4j.Logger");
        }
        catch (Throwable t) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("java.util.logging.Logger") && null != Class.forName("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable t) {
            jdk14IsAvailable = false;
        }
        String name = null;
        try {
            name = System.getProperty("com.alibaba.schedulerx.shade.org.apache.commons.logging.log");
            if (name == null) {
                name = System.getProperty("com.alibaba.schedulerx.shade.org.apache.commons.logging.Log");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (name != null) {
            try {
                LogSource.setLogImplementation(name);
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable u) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation("com.alibaba.schedulerx.shade.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

