/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.impl.conn;

import com.alibaba.schedulerx.shade.org.apache.http.impl.conn.Wire;
import java.io.IOException;
import java.io.OutputStream;

class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream out, Wire wire2) {
        this.out = out;
        this.wire = wire2;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.wire.output(b);
        }
        catch (IOException ex) {
            this.wire.output("[write] I/O error: " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.wire.output(b);
            this.out.write(b);
        }
        catch (IOException ex) {
            this.wire.output("[write] I/O error: " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len2) throws IOException {
        try {
            this.wire.output(b, off, len2);
            this.out.write(b, off, len2);
        }
        catch (IOException ex) {
            this.wire.output("[write] I/O error: " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            this.wire.output("[flush] I/O error: " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException ex) {
            this.wire.output("[close] I/O error: " + ex.getMessage());
            throw ex;
        }
    }
}

