/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.buffer;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.AbstractChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBufferFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.DuplicatedChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.HeapChannelBufferFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.SlicedChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.TruncatedChannelBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class DynamicChannelBuffer
extends AbstractChannelBuffer {
    private final ChannelBufferFactory factory;
    private final ByteOrder endianness;
    private ChannelBuffer buffer;

    public DynamicChannelBuffer(int estimatedLength) {
        this(ByteOrder.BIG_ENDIAN, estimatedLength);
    }

    public DynamicChannelBuffer(ByteOrder endianness, int estimatedLength) {
        this(endianness, estimatedLength, HeapChannelBufferFactory.getInstance(endianness));
    }

    public DynamicChannelBuffer(ByteOrder endianness, int estimatedLength, ChannelBufferFactory factory) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
        this.endianness = endianness;
        this.buffer = factory.getBuffer(this.order(), estimatedLength);
    }

    public void ensureWritableBytes(int minWritableBytes) {
        if (minWritableBytes <= this.writableBytes()) {
            return;
        }
        int newCapacity = this.capacity() == 0 ? 1 : this.capacity();
        int minNewCapacity = this.writerIndex() + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if ((newCapacity <<= 1) != 0) continue;
            throw new IllegalStateException("Maximum size of 2gb exceeded");
        }
        ChannelBuffer newBuffer = this.factory().getBuffer(this.order(), newCapacity);
        newBuffer.writeBytes(this.buffer, 0, this.writerIndex());
        this.buffer = newBuffer;
    }

    public ChannelBufferFactory factory() {
        return this.factory;
    }

    public ByteOrder order() {
        return this.endianness;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public byte getByte(int index2) {
        return this.buffer.getByte(index2);
    }

    public short getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    public int getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(index2);
    }

    public int getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    public long getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        this.buffer.getBytes(index2, dst);
    }

    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index2, out, length);
    }

    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index2, out, length);
    }

    public void setByte(int index2, int value2) {
        this.buffer.setByte(index2, value2);
    }

    public void setShort(int index2, int value2) {
        this.buffer.setShort(index2, value2);
    }

    public void setMedium(int index2, int value2) {
        this.buffer.setMedium(index2, value2);
    }

    public void setInt(int index2, int value2) {
        this.buffer.setInt(index2, value2);
    }

    public void setLong(int index2, long value2) {
        this.buffer.setLong(index2, value2);
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index2, src, srcIndex, length);
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index2, src, srcIndex, length);
    }

    public void setBytes(int index2, ByteBuffer src) {
        this.buffer.setBytes(index2, src);
    }

    public int setBytes(int index2, InputStream in2, int length) throws IOException {
        return this.buffer.setBytes(index2, in2, length);
    }

    public int setBytes(int index2, ScatteringByteChannel in2, int length) throws IOException {
        return this.buffer.setBytes(index2, in2, length);
    }

    public void writeByte(int value2) {
        this.ensureWritableBytes(1);
        super.writeByte(value2);
    }

    public void writeShort(int value2) {
        this.ensureWritableBytes(2);
        super.writeShort(value2);
    }

    public void writeMedium(int value2) {
        this.ensureWritableBytes(3);
        super.writeMedium(value2);
    }

    public void writeInt(int value2) {
        this.ensureWritableBytes(4);
        super.writeInt(value2);
    }

    public void writeLong(long value2) {
        this.ensureWritableBytes(8);
        super.writeLong(value2);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ByteBuffer src) {
        this.ensureWritableBytes(src.remaining());
        super.writeBytes(src);
    }

    public int writeBytes(InputStream in2, int length) throws IOException {
        this.ensureWritableBytes(length);
        return super.writeBytes(in2, length);
    }

    public int writeBytes(ScatteringByteChannel in2, int length) throws IOException {
        this.ensureWritableBytes(length);
        return super.writeBytes(in2, length);
    }

    public void writeZero(int length) {
        this.ensureWritableBytes(length);
        super.writeZero(length);
    }

    public ChannelBuffer duplicate() {
        return new DuplicatedChannelBuffer(this);
    }

    public ChannelBuffer copy(int index2, int length) {
        DynamicChannelBuffer copiedBuffer = new DynamicChannelBuffer(this.order(), Math.max(length, 64), this.factory());
        copiedBuffer.buffer = this.buffer.copy(index2, length);
        copiedBuffer.setIndex(0, length);
        return copiedBuffer;
    }

    public ChannelBuffer slice(int index2, int length) {
        if (index2 == 0) {
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            return new TruncatedChannelBuffer(this, length);
        }
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this, index2, length);
    }

    public ByteBuffer toByteBuffer(int index2, int length) {
        return this.buffer.toByteBuffer(index2, length);
    }
}

