/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.base64;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandler;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.base64.Base64;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.base64.Base64Dialect;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class Base64Encoder
extends OneToOneEncoder {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer src = (ChannelBuffer)msg;
        return Base64.encode(src, src.readerIndex(), src.readableBytes(), this.breakLines, this.dialect);
    }
}

