/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart;

import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.Attribute;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.DiskAttribute;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.DiskFileUpload;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.FileUpload;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.HttpData;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.HttpDataFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.MemoryAttribute;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.MemoryFileUpload;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.MixedAttribute;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.multipart.MixedFileUpload;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = new ConcurrentHashMap<HttpRequest, List<HttpData>>();

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public DefaultHttpDataFactory(boolean useDisk) {
        this.useDisk = useDisk;
        this.checkSize = false;
    }

    public DefaultHttpDataFactory(long minSize) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = minSize;
    }

    @Override
    public void setMaxLimit(long max2) {
        this.maxSize = max2;
    }

    private List<HttpData> getList(HttpRequest request2) {
        List<HttpData> list = this.requestFileDeleteMap.get(request2);
        if (list == null) {
            list = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put(request2, list);
        }
        return list;
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name) {
        if (this.useDisk) {
            DiskAttribute attribute = new DiskAttribute(name);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, this.minSize);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(attribute);
            return attribute;
        }
        MemoryAttribute attribute = new MemoryAttribute(name);
        attribute.setMaxSize(this.maxSize);
        return attribute;
    }

    private void checkHttpDataSize(HttpData data) {
        try {
            data.checkSize(data.length());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name, String value2) {
        if (this.useDisk) {
            Attribute attribute;
            try {
                attribute = new DiskAttribute(name, value2);
                attribute.setMaxSize(this.maxSize);
            }
            catch (IOException e) {
                attribute = new MixedAttribute(name, value2, this.minSize);
                attribute.setMaxSize(this.maxSize);
            }
            this.checkHttpDataSize(attribute);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, value2, this.minSize);
            attribute.setMaxSize(this.maxSize);
            this.checkHttpDataSize(attribute);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(attribute);
            return attribute;
        }
        try {
            MemoryAttribute attribute = new MemoryAttribute(name, value2);
            attribute.setMaxSize(this.maxSize);
            this.checkHttpDataSize(attribute);
            return attribute;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileUpload createFileUpload(HttpRequest request2, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size2) {
        if (this.useDisk) {
            DiskFileUpload fileUpload = new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size2);
            fileUpload.setMaxSize(this.maxSize);
            this.checkHttpDataSize(fileUpload);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(fileUpload);
            return fileUpload;
        }
        if (this.checkSize) {
            MixedFileUpload fileUpload = new MixedFileUpload(name, filename, contentType, contentTransferEncoding, charset, size2, this.minSize);
            fileUpload.setMaxSize(this.maxSize);
            this.checkHttpDataSize(fileUpload);
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.add(fileUpload);
            return fileUpload;
        }
        MemoryFileUpload fileUpload = new MemoryFileUpload(name, filename, contentType, contentTransferEncoding, charset, size2);
        fileUpload.setMaxSize(this.maxSize);
        this.checkHttpDataSize(fileUpload);
        return fileUpload;
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest request2, InterfaceHttpData data) {
        if (data instanceof HttpData) {
            List<HttpData> fileToDelete = this.getList(request2);
            fileToDelete.remove(data);
        }
    }

    @Override
    public void cleanRequestHttpDatas(HttpRequest request2) {
        List<HttpData> fileToDelete = this.requestFileDeleteMap.remove(request2);
        if (fileToDelete != null) {
            for (HttpData data : fileToDelete) {
                data.delete();
            }
            fileToDelete.clear();
        }
    }

    @Override
    public void cleanAllHttpDatas() {
        for (HttpRequest request2 : this.requestFileDeleteMap.keySet()) {
            List<HttpData> fileToDelete = this.requestFileDeleteMap.get(request2);
            if (fileToDelete != null) {
                for (HttpData data : fileToDelete) {
                    data.delete();
                }
                fileToDelete.clear();
            }
            this.requestFileDeleteMap.remove(request2);
        }
    }
}

