/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.stream;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.stream.ChunkedInput;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;

    public ChunkedStream(InputStream in2) {
        this(in2, 8192);
    }

    public ChunkedStream(InputStream in2, int chunkSize) {
        if (in2 == null) {
            throw new NullPointerException("in");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in2 instanceof PushbackInputStream ? (PushbackInputStream)in2 : new PushbackInputStream(in2);
        this.chunkSize = chunkSize;
    }

    public long getTransferredBytes() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        int b = this.in.read();
        if (b < 0) {
            return false;
        }
        this.in.unread(b);
        return true;
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.in.close();
    }

    public Object nextChunk() throws Exception {
        int localReadBytes;
        if (!this.hasNextChunk()) {
            return null;
        }
        int availableBytes = this.in.available();
        int chunkSize = availableBytes <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        byte[] chunk = new byte[chunkSize];
        int readBytes2 = 0;
        while ((localReadBytes = this.in.read(chunk, readBytes2, chunkSize - readBytes2)) >= 0) {
            this.offset += (long)localReadBytes;
            if ((readBytes2 += localReadBytes) != chunkSize) continue;
            break;
        }
        return ChannelBuffers.wrappedBuffer(chunk, 0, readBytes2);
    }
}

