/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import akka.actor.ActorSelection;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.protocol.utils.FutureUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.processor.JobProcessor;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.util.JavaProcessorProfileUtil;
import java.io.IOException;

public class StandaloneTaskMaster
extends TaskMaster {
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(StandaloneTaskMaster.class);

    public StandaloneTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
    }

    @Override
    public void submitInstance(JobInstanceInfo info) {
        ActorSelection selection = this.getActorContext().actorSelection(this.getLocalContainerRouterPath());
        long taskId = this.aquireTaskId();
        String uniqueId = IdUtil.getUniqueId(info.getJobId(), info.getJobInstanceId(), taskId);
        Worker.MasterStartContainerRequest request2 = this.convert2StartContainerRequest(info, taskId);
        try {
            Worker.MasterStartContainerResponse response = (Worker.MasterStartContainerResponse)FutureUtils.awaitResult(selection, (Object)request2, 10L);
            if (response.getSuccess()) {
                this.taskStatusMap.put(uniqueId, TaskStatus.INIT);
                this.logCollector.collect(uniqueId, "[StandaloneTaskMaster-submitTask]standalone task init success.");
            } else {
                LOGGER.error("submitTask error.", response.getMessage());
                this.taskStatusMap.put(uniqueId, TaskStatus.FAILED);
                this.logCollector.collect(uniqueId, ClientLoggerMessage.appendMessage("[StandaloneTaskMaster-submitTask]standalone task init fail. ", response.getMessage()));
            }
            this.init();
        }
        catch (Throwable e) {
            LOGGER.error("submitTask error.", e);
            this.logCollector.collect(uniqueId, "[StandaloneTaskMaster-submitTask]standalone task init fail. ", e);
            this.taskStatusMap.put(uniqueId, TaskStatus.FAILED);
        }
    }

    @Override
    public void killInstance(String reason) {
        super.killInstance(reason);
        this.updateNewInstanceStatus(this.getSerialNum(), this.jobInstanceInfo.getJobInstanceId(), InstanceStatus.FAILED, reason);
        Worker.MasterKillContainerResponse response = null;
        ActorSelection selection = this.getActorContext().actorSelection(this.getLocalContainerRouterPath());
        String uniqueId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        if (!this.instanceStatus.isFinish()) {
            this.instanceStatus = InstanceStatus.FAILED;
        }
        try {
            Worker.MasterKillContainerRequest request2 = Worker.MasterKillContainerRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).build();
            response = (Worker.MasterKillContainerResponse)FutureUtils.awaitResult(selection, (Object)request2, 10L);
            if (response.getSuccess()) {
                LOGGER.info("[StandaloneTaskMaster]kill standalone instance success, uniqueId:{}", uniqueId);
            } else {
                LOGGER.warn("[StandaloneTaskMaster]kill standalone instance failed, uniqueId:{}", uniqueId);
            }
        }
        catch (Throwable e) {
            LOGGER.error("[StandaloneTaskMaster]kill standalone instance exception uniqueId:{}", uniqueId, e);
        }
    }

    @Override
    public void destroyContainerPool() {
        try {
            ActorSelection selection = this.getActorContext().actorSelection(this.getLocalContainerRouterPath());
            Worker.MasterDestroyContainerPoolRequest request2 = Worker.MasterDestroyContainerPoolRequest.newBuilder().setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setSerialNum(this.getSerialNum()).build();
            FutureUtils.awaitResult(selection, (Object)request2, 5L);
        }
        catch (Throwable e) {
            LOGGER.error("destroy containerPool failed", e);
        }
    }

    @Override
    protected void checkProcessor() throws Exception {
        JobProcessor processor;
        if ("java".equalsIgnoreCase(this.jobInstanceInfo.getJobType()) && (processor = JavaProcessorProfileUtil.getJavaProcessor(this.jobInstanceInfo.getContent())) instanceof MapJobProcessor) {
            throw new IOException(processor.getClass().getName() + " shouldn't extends MapJobProcessor or MapReduceJobProcessor");
        }
    }
}

