/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.domain.LimitedQueue;
import com.alibaba.schedulerx.common.domain.Metrics;
import com.alibaba.schedulerx.common.monitor.MetricsCollector;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.metrics.CgroupMetrics;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.math.BigDecimal;

public class MetricsCollectorTimer
extends AbstractTimerTask {
    private static int QUEUE_LIMIT = 5;
    private static final LimitedQueue<Double> LOAD_QUEUE = new LimitedQueue(QUEUE_LIMIT);
    private static final LimitedQueue<Double> HEAP_QUEUE = new LimitedQueue(QUEUE_LIMIT);
    private boolean enableCgroup = ConfigUtil.getWorkerConfig().getBoolean("cgroup.metrics.enable", false);

    @Override
    public String getName() {
        return "MetricsCollectorTimer";
    }

    @Override
    public long getInitialDelay() {
        return 10L;
    }

    @Override
    public long getPeriod() {
        return 60L;
    }

    @Override
    public void run() {
        try {
            Metrics metrics = new Metrics();
            this.buildCPUInfo(metrics);
            this.buildJvmHeapInfo(metrics);
            this.buildDiskInfo(metrics);
            MetricsCollector.setMetrics(metrics);
            LOGGER.info("enableCgroup={}, cpuUsage={}, jvmHeapUsage={}, diskUsage={}", this.enableCgroup, metrics.getCpuLoad5(), metrics.getHeap1Usage(), metrics.getDiskUsage());
        }
        catch (Throwable ex) {
            LOGGER.error("MetricsCollectorTimer error.", ex);
        }
    }

    private void buildDiskInfo(Metrics metrics) {
        File[] roots = File.listRoots();
        int free = 0;
        int total = 0;
        for (File file : roots) {
            if (file == null) continue;
            free = (int)((long)free + file.getFreeSpace() / 1024L / 1024L);
            total = (int)((long)total + file.getTotalSpace() / 1024L / 1024L);
        }
        metrics.setDiskUsed(total - free);
        metrics.setDiskMax(total);
        if (total != 0) {
            metrics.setDiskUsage((double)metrics.getDiskUsed() / (double)total);
        } else {
            metrics.setDiskUsage(0.0);
        }
    }

    private void buildCPUInfo(Metrics metrics) {
        if (this.enableCgroup) {
            CgroupMetrics cGroupMetrics = CgroupMetrics.getInstance();
            metrics.setCpuProcessors(cGroupMetrics.getCpuCores());
            BigDecimal bd = new BigDecimal(cGroupMetrics.getCpuUsagePercent());
            double cpuLoad = bd.setScale(2, 4).doubleValue();
            metrics.setCpuLoad1(cpuLoad);
            metrics.setCpuLoad5(cpuLoad);
        } else {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            metrics.setCpuProcessors(operatingSystemMXBean.getAvailableProcessors());
            LOAD_QUEUE.offer(operatingSystemMXBean.getSystemLoadAverage());
            Object[] loads = LOAD_QUEUE.toArray();
            double totalLoads = 0.0;
            for (Object o : loads) {
                totalLoads += ((Double)o).doubleValue();
            }
            metrics.setCpuLoad1((Double)loads[loads.length - 1]);
            metrics.setCpuLoad5(totalLoads / (double)loads.length);
        }
    }

    private void buildJvmHeapInfo(Metrics metrics) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        int used = (int)(memoryUsage.getUsed() / 1024L / 1024L);
        int max2 = (int)(memoryUsage.getMax() / 1024L / 1024L);
        metrics.setHeap1Used(used);
        metrics.setHeapMax(max2);
        metrics.setHeap1Usage((double)used / (double)max2);
        HEAP_QUEUE.offer(metrics.getHeap1Usage());
        Object[] heaps = HEAP_QUEUE.toArray();
        double totalHeap = 0.0;
        for (Object o : heaps) {
            totalHeap += ((Double)o).doubleValue();
        }
        metrics.setHeap5Usage(totalHeap / (double)heaps.length);
    }
}

