/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.commons.beanutils;

import com.alibaba.schedulerx.shade.org.apache.commons.collections.Transformer;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.BeanUtils;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import java.lang.reflect.InvocationTargetException;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.ignoreNull = ignoreNull;
    }

    public Object transform(Object object) {
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during transformation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during transformation. Null value encountered in property path..." + e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("Problem during transformation. Null value encountered in property path...");
            if (!BeanUtils.initCause(iae, e)) {
                this.log.error("Problem during transformation. Null value encountered in property path...", e);
            }
            throw iae;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access the property provided.");
            if (!BeanUtils.initCause(iae, e)) {
                this.log.error("Unable to access the property provided.", e);
            }
            throw iae;
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            IllegalArgumentException iae = new IllegalArgumentException("Exception occurred in property's getter");
            if (!BeanUtils.initCause(iae, e)) {
                this.log.error("Exception occurred in property's getter", e);
            }
            throw iae;
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "No property found for name [" + this.propertyName + "]";
            IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
            if (!BeanUtils.initCause(iae, e)) {
                this.log.error(errorMsg, e);
            }
            throw iae;
        }
        return propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

