/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.commons.beanutils;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.ContextClassLoaderLocal;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.ConvertUtilsBean;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.Converter;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaBean;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaClass;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaProperty;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.MappedPropertyDescriptor;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.PropertyUtilsBean;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.expression.Resolver;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanUtilsBean {
    private static final ContextClassLoaderLocal BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal(){

        protected Object initialValue() {
            return new BeanUtilsBean();
        }
    };
    private Log log = LogFactory.getLog(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtilsBean.class$("com.aliyun.log.thirdparty.org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils);
    private ConvertUtilsBean convertUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;
    private static final Method INIT_CAUSE_METHOD = BeanUtilsBean.getInitCauseMethod();
    static /* synthetic */ Class class$org$apache$commons$beanutils$BeanUtils;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static BeanUtilsBean getInstance() {
        return (BeanUtilsBean)BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(BeanUtilsBean newInstance) {
        BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public BeanUtilsBean() {
        this(new ConvertUtilsBean(), new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean) {
        this(convertUtilsBean, new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        this.convertUtilsBean = convertUtilsBean;
        this.propertyUtilsBean = propertyUtilsBean;
    }

    public Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cloning bean: " + bean.getClass().getName());
        }
        DynaBean newBean = null;
        newBean = bean instanceof DynaBean ? ((DynaBean)bean).getDynaClass().newInstance() : (DynaBean)bean.getClass().newInstance();
        this.getPropertyUtils().copyProperties(newBean, bean);
        return newBean;
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.copyProperties(" + dest + ", " + orig + ")");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!this.getPropertyUtils().isReadable(orig, name) || !this.getPropertyUtils().isWriteable(dest, name)) continue;
                Object value2 = ((DynaBean)orig).get(name);
                this.copyProperty(dest, name, value2);
            }
        } else if (orig instanceof Map) {
            Iterator entries = ((Map)orig).entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                if (!this.getPropertyUtils().isWriteable(dest, name)) continue;
                this.copyProperty(dest, name, entry.getValue());
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyUtils().getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !this.getPropertyUtils().isReadable(orig, name) || !this.getPropertyUtils().isWriteable(dest, name)) continue;
                try {
                    Object value3 = this.getPropertyUtils().getSimpleProperty(orig, name);
                    this.copyProperty(dest, name, value3);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
    }

    public void copyProperty(Object bean, String name, Object value2) throws IllegalAccessException, InvocationTargetException {
        if (this.log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("  copyProperty(");
            sb.append(bean);
            sb.append(", ");
            sb.append(name);
            sb.append(", ");
            if (value2 == null) {
                sb.append("<NULL>");
            } else if (value2 instanceof String) {
                sb.append((String)value2);
            } else if (value2 instanceof String[]) {
                String[] values2 = (String[])value2;
                sb.append('[');
                for (int i = 0; i < values2.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values2[i]);
                }
                sb.append(']');
            } else {
                sb.append(value2.toString());
            }
            sb.append(')');
            this.log.trace(sb.toString());
        }
        Object target = bean;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name));
                name = resolver.remove(name);
            }
            catch (NoSuchMethodException e) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name);
        }
        String propName = resolver.getProperty(name);
        Class<?> type = null;
        int index2 = resolver.getIndex(name);
        String key = resolver.getKey(name);
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return;
            }
            type = dynaProperty.getType();
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyUtils().getPropertyDescriptor(target, name);
                if (descriptor == null) {
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                return;
            }
            type = descriptor.getPropertyType();
            if (type == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("    target type for property '" + propName + "' is null, so skipping ths setter");
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    target propName=" + propName + ", type=" + type + ", index=" + index2 + ", key=" + key);
        }
        if (index2 >= 0) {
            value2 = this.convert(value2, type.getComponentType());
            try {
                this.getPropertyUtils().setIndexedProperty(target, propName, index2, value2);
            }
            catch (NoSuchMethodException e) {
                throw new InvocationTargetException(e, "Cannot set " + propName);
            }
        }
        if (key != null) {
            try {
                this.getPropertyUtils().setMappedProperty(target, propName, key, value2);
            }
            catch (NoSuchMethodException e) {
                throw new InvocationTargetException(e, "Cannot set " + propName);
            }
        }
        value2 = this.convert(value2, type);
        try {
            this.getPropertyUtils().setSimpleProperty(target, propName, value2);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, "Cannot set " + propName);
        }
    }

    public Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            return new HashMap();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Describing bean: " + bean.getClass().getName());
        }
        HashMap<String, String> description = new HashMap<String, String>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                description.put(name, this.getProperty(bean, name));
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyUtils().getPropertyDescriptors(bean);
            Class<?> clazz = bean.getClass();
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if (this.getPropertyUtils().getReadMethod(clazz, descriptors[i]) == null) continue;
                description.put(name, this.getProperty(bean, name));
            }
        }
        return description;
    }

    public String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getProperty(bean, name);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Collection) {
            ArrayList<String> values2 = new ArrayList<String>();
            Iterator items = ((Collection)value2).iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (item == null) {
                    values2.add(null);
                    continue;
                }
                values2.add(this.getConvertUtils().convert(item));
            }
            return values2.toArray(new String[values2.size()]);
        }
        if (value2.getClass().isArray()) {
            int n = Array.getLength(value2);
            String[] results = new String[n];
            for (int i = 0; i < n; ++i) {
                Object item = Array.get(value2, i);
                results[i] = item == null ? null : this.getConvertUtils().convert(item);
            }
            return results;
        }
        String[] results = new String[]{this.getConvertUtils().convert(value2)};
        return results;
    }

    public String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getIndexedProperty(bean, name);
        return this.getConvertUtils().convert(value2);
    }

    public String getIndexedProperty(Object bean, String name, int index2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getIndexedProperty(bean, name, index2);
        return this.getConvertUtils().convert(value2);
    }

    public String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getMappedProperty(bean, name);
        return this.getConvertUtils().convert(value2);
    }

    public String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getMappedProperty(bean, name, key);
        return this.getConvertUtils().convert(value2);
    }

    public String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getNestedProperty(bean, name);
        return this.getConvertUtils().convert(value2);
    }

    public String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getSimpleProperty(bean, name);
        return this.getConvertUtils().convert(value2);
    }

    public void populate(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.populate(" + bean + ", " + properties + ")");
        }
        Iterator entries = properties.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            if (name == null) continue;
            this.setProperty(bean, name, entry.getValue());
        }
    }

    public void setProperty(Object bean, String name, Object value2) throws IllegalAccessException, InvocationTargetException {
        if (this.log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("  setProperty(");
            sb.append(bean);
            sb.append(", ");
            sb.append(name);
            sb.append(", ");
            if (value2 == null) {
                sb.append("<NULL>");
            } else if (value2 instanceof String) {
                sb.append((String)value2);
            } else if (value2 instanceof String[]) {
                String[] values2 = (String[])value2;
                sb.append('[');
                for (int i = 0; i < values2.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values2[i]);
                }
                sb.append(']');
            } else {
                sb.append(value2.toString());
            }
            sb.append(')');
            this.log.trace(sb.toString());
        }
        Object target = bean;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name));
                name = resolver.remove(name);
            }
            catch (NoSuchMethodException e) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name);
        }
        String propName = resolver.getProperty(name);
        Class type = null;
        int index2 = resolver.getIndex(name);
        String key = resolver.getKey(name);
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return;
            }
            type = dynaProperty.getType();
        } else if (target instanceof Map) {
            type = class$java$lang$Object == null ? (class$java$lang$Object = BeanUtilsBean.class$("java.lang.Object")) : class$java$lang$Object;
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyUtils().getPropertyDescriptor(target, name);
                if (descriptor == null) {
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                return;
            }
            if (descriptor instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)descriptor).getMappedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type = ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
            } else if (index2 >= 0 && descriptor instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type = ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
            } else if (key != null) {
                if (descriptor.getReadMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                Class clazz = value2 == null ? (class$java$lang$Object == null ? (class$java$lang$Object = BeanUtilsBean.class$("java.lang.Object")) : class$java$lang$Object) : value2.getClass();
                type = clazz;
            } else {
                if (descriptor.getWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type = descriptor.getPropertyType();
            }
        }
        Object newValue = null;
        if (type.isArray() && index2 < 0) {
            if (value2 == null) {
                String[] values3 = new String[]{(String)value2};
                newValue = this.getConvertUtils().convert(values3, type);
            } else {
                newValue = value2 instanceof String ? this.getConvertUtils().convert(value2, type) : (value2 instanceof String[] ? this.getConvertUtils().convert((String[])value2, type) : this.convert(value2, type));
            }
        } else {
            newValue = type.isArray() ? (value2 instanceof String || value2 == null ? this.getConvertUtils().convert((String)value2, type.getComponentType()) : (value2 instanceof String[] ? this.getConvertUtils().convert(((String[])value2)[0], type.getComponentType()) : this.convert(value2, type.getComponentType()))) : (value2 instanceof String || value2 == null ? this.getConvertUtils().convert((String)value2, type) : (value2 instanceof String[] ? this.getConvertUtils().convert(((String[])value2)[0], type) : this.convert(value2, type)));
        }
        try {
            this.getPropertyUtils().setProperty(target, name, newValue);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, "Cannot set " + propName);
        }
    }

    public ConvertUtilsBean getConvertUtils() {
        return this.convertUtilsBean;
    }

    public PropertyUtilsBean getPropertyUtils() {
        return this.propertyUtilsBean;
    }

    public boolean initCause(Throwable throwable, Throwable cause) {
        if (INIT_CAUSE_METHOD != null && cause != null) {
            try {
                INIT_CAUSE_METHOD.invoke((Object)throwable, cause);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    protected Object convert(Object value2, Class type) {
        Converter converter = this.getConvertUtils().lookup(type);
        if (converter != null) {
            this.log.trace("        USING CONVERTER " + converter);
            return converter.convert(type, value2);
        }
        return value2;
    }

    private static Method getInitCauseMethod() {
        try {
            Class[] paramsClasses = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = BeanUtilsBean.class$("java.lang.Throwable")) : class$java$lang$Throwable};
            return (class$java$lang$Throwable == null ? (class$java$lang$Throwable = BeanUtilsBean.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", paramsClasses);
        }
        catch (NoSuchMethodException e) {
            Log log2 = LogFactory.getLog(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtilsBean.class$("com.aliyun.log.thirdparty.org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils);
            if (log2.isWarnEnabled()) {
                log2.warn("Throwable does not have initCause() method in JDK 1.3");
            }
            return null;
        }
        catch (Throwable e) {
            Log log3 = LogFactory.getLog(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtilsBean.class$("com.aliyun.log.thirdparty.org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils);
            if (log3.isWarnEnabled()) {
                log3.warn("Error getting the Throwable initCause() method", e);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

