/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class LessEngineCli {
    public static void main(String[] args) throws LessException, URISyntaxException {
        Options cmdOptions = new Options();
        cmdOptions.addOption("charset", true, "Input file charset encoding. Defaults to UTF-8.");
        cmdOptions.addOption("compress", false, "Flag that enables compressed CSS output.");
        cmdOptions.addOption("css", false, "Flag that enables compilation of .css files.");
        cmdOptions.addOption("less", true, "Path to a custom less.js for Rhino version.");
        cmdOptions.addOption("dumpLineNumbers", true, "Dump line numbers ( comments | mediaquery | all ).");
        cmdOptions.addOption("source-map", true, "Flag that enables the generation of a source map.");
        cmdOptions.addOption("source-map-rootpath", true, "Source map root path.");
        cmdOptions.addOption("source-map-basepath", true, "Source map base path.");
        cmdOptions.addOption("source-map-url", true, "Source map URL.");
        try {
            String[] files;
            GnuParser cmdParser = new GnuParser();
            CommandLine cmdLine = cmdParser.parse(cmdOptions, args);
            LessOptions options = new LessOptions();
            if (cmdLine.hasOption("charset")) {
                options.setCharset(cmdLine.getOptionValue("charset"));
            }
            if (cmdLine.hasOption("compress")) {
                options.setCompress(true);
            }
            if (cmdLine.hasOption("css")) {
                options.setCss(true);
            }
            if (cmdLine.hasOption("less")) {
                options.setLess(new File(cmdLine.getOptionValue("less")).toURI().toURL());
            }
            if (cmdLine.hasOption("dumpLineNumbers")) {
                options.setLineNumbers(cmdLine.getOptionValue("dumpLineNumbers"));
            }
            if (cmdLine.hasOption("source-map")) {
                options.setSourceMap(true);
            }
            if (cmdLine.hasOption("source-map-rootpath")) {
                options.setSourceMapRootpath(cmdLine.getOptionValue("source-map-rootpath"));
            }
            if (cmdLine.hasOption("source-map-basepath")) {
                options.setSourceMapBasepath(cmdLine.getOptionValue("source-map-basepath"));
            }
            if (cmdLine.hasOption("source-map-url")) {
                options.setSourceMapUrl(cmdLine.getOptionValue("source-map-url"));
            }
            LessEngine engine = new LessEngine(options);
            if (System.in.available() != 0) {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                StringWriter sw = new StringWriter();
                char[] buffer = new char[1024];
                int n = 0;
                while (-1 != (n = in.read(buffer))) {
                    sw.write(buffer, 0, n);
                }
                String src = sw.toString();
                if (!src.isEmpty()) {
                    System.out.println(engine.compile(src, null, options.isCompress()));
                    System.exit(0);
                }
            }
            if ((files = cmdLine.getArgs()).length == 1) {
                System.out.println(engine.compile(new File(files[0]), options.isCompress()));
                System.exit(0);
            }
            if (files.length == 2) {
                engine.compile(new File(files[0]), new File(files[1]), options.isCompress());
                System.exit(0);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error opening input file.");
        }
        catch (ParseException pe) {
            System.err.println("Error parsing arguments.");
        }
        String[] paths = LessEngine.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().split(File.separator);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar " + paths[paths.length - 1] + " input [output] [options]", cmdOptions);
        System.exit(1);
    }
}

