/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss.compiler;

import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.compiler.LessCompiler;
import com.asual.lesscss.loader.ResourceLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.tools.shell.Global;

public class RhinoCompiler
implements LessCompiler {
    private Scriptable scope;
    private final Function compile;
    private final Log logger = LogFactory.getLog(this.getClass());

    public RhinoCompiler(LessOptions options, ResourceLoader loader, URL less, URL env, URL engine, URL cssmin, URL sourceMap) throws IOException {
        Context cx = Context.enter();
        this.logger.debug((Object)("Using implementation version: " + cx.getImplementationVersion()));
        cx.setOptimizationLevel(-1);
        Global global = new Global();
        global.init(cx);
        this.scope = cx.initStandardObjects((ScriptableObject)global);
        cx.evaluateReader(this.scope, (Reader)new InputStreamReader(sourceMap.openConnection().getInputStream()), sourceMap.getFile(), 1, null);
        cx.evaluateReader(this.scope, (Reader)new InputStreamReader(env.openConnection().getInputStream()), env.getFile(), 1, null);
        Scriptable lessEnv = (Scriptable)this.scope.get("lessenv", this.scope);
        lessEnv.put("charset", lessEnv, (Object)options.getCharset());
        lessEnv.put("css", lessEnv, (Object)options.isCss());
        lessEnv.put("lineNumbers", lessEnv, (Object)options.getLineNumbers());
        lessEnv.put("optimization", lessEnv, (Object)options.getOptimization());
        lessEnv.put("sourceMap", lessEnv, (Object)options.isSourceMap());
        lessEnv.put("sourceMapRootpath", lessEnv, (Object)options.getSourceMapRootpath());
        lessEnv.put("sourceMapBasepath", lessEnv, (Object)options.getSourceMapBasepath());
        lessEnv.put("sourceMapURL", lessEnv, (Object)options.getSourceMapUrl());
        lessEnv.put("loader", lessEnv, Context.javaToJS((Object)loader, (Scriptable)this.scope));
        if (options.getPaths() != null) {
            NativeArray nativeArray = new NativeArray((Object[])options.getPaths());
            lessEnv.put("paths", lessEnv, (Object)nativeArray);
        }
        cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less.openConnection().getInputStream()), less.getFile(), 1, null);
        cx.evaluateReader(this.scope, (Reader)new InputStreamReader(cssmin.openConnection().getInputStream()), cssmin.getFile(), 1, null);
        cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine.openConnection().getInputStream()), engine.getFile(), 1, null);
        this.compile = (Function)this.scope.get("compile", this.scope);
    }

    @Override
    public String compile(String input, String location, boolean compress) throws LessException {
        try {
            return this.call(this.compile, new Object[]{input, location, compress});
        }
        catch (Exception e) {
            throw new LessException(this.parseLessException(e));
        }
    }

    private String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private boolean hasProperty(Scriptable value, String name) {
        Object property = ScriptableObject.getProperty((Scriptable)value, (String)name);
        return property != null && !property.equals(UniqueTag.NOT_FOUND);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug((Object)"Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            String type = ScriptableObject.getProperty((Scriptable)value, (String)"type").toString() + " Error";
            String message = ScriptableObject.getProperty((Scriptable)value, (String)"message").toString();
            String filename = "";
            if (this.hasProperty(value, "filename")) {
                filename = ScriptableObject.getProperty((Scriptable)value, (String)"filename").toString();
            }
            int line = -1;
            if (this.hasProperty(value, "line")) {
                line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
            }
            int column = -1;
            if (this.hasProperty(value, "column")) {
                column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
            }
            ArrayList<String> extractList = new ArrayList<String>();
            if (this.hasProperty(value, "extract")) {
                NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                int i = 0;
                while ((long)i < extract.getLength()) {
                    if (extract.get(i, (Scriptable)extract) instanceof String) {
                        extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                    }
                    ++i;
                }
            }
            throw new LessException(message, type, filename, line, column, extractList);
        }
        throw new LessException(root);
    }
}

