/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhub;

import com.azure.core.management.AzureEnvironment;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.eventhub.AzureEventHubProperties;
import com.azure.spring.cloud.context.core.api.EnvironmentProvider;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.EventHubNamespaceManager;
import com.azure.spring.cloud.context.core.impl.StorageAccountManager;
import com.azure.spring.cloud.context.core.storage.StorageConnectionStringProvider;
import com.azure.spring.integration.eventhub.api.EventHubClientFactory;
import com.azure.spring.integration.eventhub.api.EventHubOperation;
import com.azure.spring.integration.eventhub.factory.DefaultEventHubClientFactory;
import com.azure.spring.integration.eventhub.factory.EventHubConnectionStringProvider;
import com.azure.spring.integration.eventhub.impl.EventHubTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnClass(value={EventHubConsumerAsyncClient.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhub.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureEventHubProperties.class})
public class AzureEventHubAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureEventHubAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AzureResourceManager.class})
    public EventHubNamespaceManager eventHubNamespaceManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        return new EventHubNamespaceManager(azureResourceManager, azureProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AzureResourceManager.class})
    @ConditionalOnProperty(value={"spring.cloud.azure.eventhub.checkpoint-storage-account"})
    public StorageAccountManager storageAccountManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        return new StorageAccountManager(azureResourceManager, azureProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubConnectionStringProvider eventHubConnectionStringProvider(@Autowired(required=false) EventHubNamespaceManager namespaceManager, AzureEventHubProperties properties) {
        String namespace = properties.getNamespace();
        String connectionString = properties.getConnectionString();
        if (StringUtils.hasText((String)connectionString)) {
            return new EventHubConnectionStringProvider(connectionString);
        }
        if (namespaceManager != null && StringUtils.hasText((String)namespace)) {
            return new EventHubConnectionStringProvider((EventHubNamespace)namespaceManager.getOrCreate((Object)namespace));
        }
        LOGGER.warn("Can't construct the EventHubConnectionStringProvider, namespace: {}, connectionString: {}", (Object)namespace, (Object)connectionString);
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubClientFactory eventhubClientFactory(@Autowired(required=false) EnvironmentProvider environmentProvider, @Autowired(required=false) StorageAccountManager storageAccountManager, EventHubConnectionStringProvider eventHubConnectionStringProvider, AzureEventHubProperties properties) {
        if (eventHubConnectionStringProvider == null) {
            LOGGER.info("No event hub connection string provided.");
            return null;
        }
        String eventHubConnectionString = eventHubConnectionStringProvider.getConnectionString();
        String storageConnectionString = this.getStorageConnectionString(properties, storageAccountManager, environmentProvider == null ? null : environmentProvider.getEnvironment());
        return new DefaultEventHubClientFactory(eventHubConnectionString, storageConnectionString, properties.getCheckpointContainer());
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubOperation eventHubOperation(EventHubClientFactory clientFactory) {
        return new EventHubTemplate(clientFactory);
    }

    private String getStorageConnectionString(AzureEventHubProperties properties, StorageAccountManager storageAccountManager, AzureEnvironment azureEnvironment) {
        String accountName = properties.getCheckpointStorageAccount();
        String accountKey = properties.getCheckpointAccessKey();
        if (accountName == null) {
            return null;
        }
        StorageConnectionStringProvider provider = storageAccountManager != null ? new StorageConnectionStringProvider((StorageAccount)storageAccountManager.getOrCreate((Object)accountName)) : new StorageConnectionStringProvider(accountName, accountKey, azureEnvironment);
        return provider.getConnectionString();
    }
}

