/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhub;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.AuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationKey;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.eventhub.AzureEventHubProperties;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.EventHubNamespaceManager;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnProperty(prefix="spring.cloud.azure.eventhub", value={"namespace"})
@EnableConfigurationProperties(value={AzureEventHubProperties.class})
public class AzureEventHubKafkaAutoConfiguration {
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String SASL_SSL = "SASL_SSL";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_CONFIG_VALUE = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"$ConnectionString\" password=\"%s\";%n";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SASL_MECHANISM_PLAIN = "PLAIN";
    private static final int PORT = 9093;

    @Primary
    @Bean
    public KafkaProperties kafkaProperties(EventHubNamespaceManager eventHubNamespaceManager, AzureEventHubProperties eventHubProperties) {
        KafkaProperties kafkaProperties = new KafkaProperties();
        EventHubNamespace namespace = (EventHubNamespace)eventHubNamespaceManager.getOrCreate((Object)eventHubProperties.getNamespace());
        String connectionString = AzureEventHubKafkaAutoConfiguration.toConnectionString(namespace);
        String endpoint = namespace.serviceBusEndpoint();
        String endpointHost = endpoint.substring("https://".length(), endpoint.lastIndexOf(58));
        kafkaProperties.setBootstrapServers(Arrays.asList(endpointHost + ":" + 9093));
        kafkaProperties.getProperties().put(SECURITY_PROTOCOL, SASL_SSL);
        kafkaProperties.getProperties().put(SASL_MECHANISM, SASL_MECHANISM_PLAIN);
        kafkaProperties.getProperties().put(SASL_JAAS_CONFIG, String.format(SASL_CONFIG_VALUE, connectionString, System.getProperty("line.separator")));
        return kafkaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AzureResourceManager.class})
    public EventHubNamespaceManager eventHubNamespaceManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        return new EventHubNamespaceManager(azureResourceManager, azureProperties);
    }

    private static String toConnectionString(EventHubNamespace eventHubNamespace) {
        return eventHubNamespace.listAuthorizationRules().stream().findFirst().map(AuthorizationRule::getKeys).map(EventHubAuthorizationKey::primaryConnectionString).orElseThrow(() -> new IllegalStateException(String.format("Failed to fetch connection string of namespace '%s'", eventHubNamespace.name()), null));
    }
}

