/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.implementation.http.BufferedHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class HttpResponse
implements Closeable {
    private final HttpRequest request;

    protected HttpResponse(HttpRequest request) {
        this.request = request;
    }

    public abstract int getStatusCode();

    public abstract String getHeaderValue(String var1);

    public abstract HttpHeaders getHeaders();

    public abstract Flux<ByteBuffer> getBody();

    public abstract Mono<byte[]> getBodyAsByteArray();

    public abstract Mono<String> getBodyAsString();

    public abstract Mono<String> getBodyAsString(Charset var1);

    public Mono<InputStream> getBodyAsInputStream() {
        return this.getBodyAsByteArray().map(ByteArrayInputStream::new);
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse buffer() {
        return new BufferedHttpResponse(this);
    }

    @Override
    public void close() {
    }
}

