/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.MemberNameConverter;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.BeanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import reactor.core.publisher.Mono;

public final class JacksonJsonSerializer
implements JsonSerializer,
MemberNameConverter {
    private static final String ACCESSOR_NAMING_STRATEGY = "com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy";
    private static final String ACCESSOR_NAMING_STRATEGY_PROVIDER = "com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy.Provider";
    private static final MethodHandle GET_ACCESSOR_NAMING;
    private static final MethodHandle FOR_POJO;
    private static final MethodHandle FIND_NAME_FOR_IS_GETTER;
    private static final MethodHandle FIND_NAME_FOR_REGULAR_GETTER;
    private static final boolean USE_REFLECTION_FOR_MEMBER_NAME;
    private final ClientLogger logger = new ClientLogger(JacksonJsonSerializer.class);
    private final ObjectMapper mapper;
    private final TypeFactory typeFactory;

    JacksonJsonSerializer(ObjectMapper mapper) {
        this.mapper = mapper;
        this.typeFactory = mapper.getTypeFactory();
    }

    public <T> T deserializeFromBytes(byte[] data, TypeReference<T> typeReference) {
        if (data == null) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(data, this.typeFactory.constructType(typeReference.getJavaType()));
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
        if (stream == null) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(stream, this.typeFactory.constructType(typeReference.getJavaType()));
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public <T> Mono<T> deserializeFromBytesAsync(byte[] data, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserializeFromBytes(data, typeReference));
    }

    public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
    }

    public byte[] serializeToBytes(Object value) {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public void serialize(OutputStream stream, Object value) {
        try {
            this.mapper.writeValue(stream, value);
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public Mono<byte[]> serializeToBytesAsync(Object value) {
        return Mono.fromCallable(() -> this.serializeToBytes(value));
    }

    public Mono<Void> serializeAsync(OutputStream stream, Object value) {
        return Mono.fromRunnable(() -> this.serialize(stream, value));
    }

    public String convertMemberName(Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        VisibilityChecker visibilityChecker = this.mapper.getVisibilityChecker();
        if (member instanceof Field) {
            Field f = (Field)member;
            if (f.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isFieldVisible(f)) {
                if (f.isAnnotationPresent(JsonProperty.class)) {
                    this.logger.info("Field {} is annotated with JsonProperty but isn't accessible to JacksonJsonSerializer.", new Object[]{f.getName()});
                }
                return null;
            }
            if (f.isAnnotationPresent(JsonProperty.class)) {
                String propertyName = f.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty((CharSequence)propertyName) ? f.getName() : propertyName;
            }
            return f.getName();
        }
        if (member instanceof Method) {
            Method m = (Method)member;
            if (!JacksonJsonSerializer.verifyGetter(m) || m.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isGetterVisible(m)) {
                if (m.isAnnotationPresent(JsonGetter.class) || m.isAnnotationPresent(JsonProperty.class)) {
                    this.logger.info("Method {} is annotated with either JsonGetter or JsonProperty but isn't accessible to JacksonJsonSerializer.", new Object[]{m.getName()});
                }
                return null;
            }
            String methodNameWithoutJavaBeans = this.removePrefix(m);
            if (m.isAnnotationPresent(JsonGetter.class)) {
                String propertyName = m.getDeclaredAnnotation(JsonGetter.class).value();
                return CoreUtils.isNullOrEmpty((CharSequence)propertyName) ? methodNameWithoutJavaBeans : propertyName;
            }
            if (m.isAnnotationPresent(JsonProperty.class)) {
                String propertyName = m.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty((CharSequence)propertyName) ? methodNameWithoutJavaBeans : propertyName;
            }
            return methodNameWithoutJavaBeans;
        }
        return null;
    }

    private static boolean verifyGetter(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getParameterCount() == 0 && returnType != Void.TYPE && returnType != Void.class;
    }

    private String removePrefix(Method method) {
        SerializationConfig config = this.mapper.getSerializationConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolve((MapperConfig)config, (JavaType)this.mapper.constructType(method.getDeclaringClass()), null);
        AnnotatedMethod annotatedMethod = new AnnotatedMethod(null, method, null, null);
        String annotatedMethodName = annotatedMethod.getName();
        String name = null;
        if (USE_REFLECTION_FOR_MEMBER_NAME) {
            name = JacksonJsonSerializer.removePrefixWithReflection(config, annotatedClass, annotatedMethod, annotatedMethodName, this.logger);
        }
        if (name == null) {
            name = JacksonJsonSerializer.removePrefixWithBeanUtils(annotatedMethod);
        }
        return name;
    }

    private static String removePrefixWithReflection(MapperConfig<?> config, AnnotatedClass annotatedClass, AnnotatedMethod method, String methodName, ClientLogger logger) {
        try {
            Object accessorNamingStrategy = FOR_POJO.invoke(GET_ACCESSOR_NAMING.invoke(config), config, annotatedClass);
            String name = FIND_NAME_FOR_IS_GETTER.invoke(accessorNamingStrategy, method, methodName);
            if (name == null) {
                name = FIND_NAME_FOR_REGULAR_GETTER.invoke(accessorNamingStrategy, method, methodName);
            }
            return name;
        }
        catch (Throwable ex) {
            logger.verbose("Failed to find member name with AccessorNamingStrategy, returning null.", new Object[]{ex});
            return null;
        }
    }

    private static String removePrefixWithBeanUtils(AnnotatedMethod annotatedMethod) {
        return BeanUtil.okNameForGetter((AnnotatedMethod)annotatedMethod, (boolean)false);
    }

    static {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        MethodHandle getAccessorNaming = null;
        MethodHandle forPojo = null;
        MethodHandle findNameForIsGetter = null;
        MethodHandle findNameForRegularGetter = null;
        boolean useReflectionForMemberName = false;
        try {
            Class<?> accessorNamingStrategyProviderClass = Class.forName(ACCESSOR_NAMING_STRATEGY_PROVIDER);
            Class<?> accessorNamingStrategyClass = Class.forName(ACCESSOR_NAMING_STRATEGY);
            getAccessorNaming = publicLookup.findVirtual(MapperConfig.class, "getAccessorNaming", MethodType.methodType(accessorNamingStrategyProviderClass));
            forPojo = publicLookup.findVirtual(accessorNamingStrategyProviderClass, "forPOJO", MethodType.methodType(accessorNamingStrategyClass, MapperConfig.class, AnnotatedClass.class));
            findNameForIsGetter = publicLookup.findVirtual(accessorNamingStrategyClass, "findNameForIsGetter", MethodType.methodType(String.class, AnnotatedMethod.class, String.class));
            findNameForRegularGetter = publicLookup.findVirtual(accessorNamingStrategyClass, "findNameForRegularGetter", MethodType.methodType(String.class, AnnotatedMethod.class, String.class));
            useReflectionForMemberName = true;
        }
        catch (Throwable ex) {
            new ClientLogger(JacksonJsonSerializer.class).verbose("Failed to retrieve MethodHandles used to get naming strategy. Falling back to BeanUtils.", new Object[]{ex});
        }
        GET_ACCESSOR_NAMING = getAccessorNaming;
        FOR_POJO = forPojo;
        FIND_NAME_FOR_IS_GETTER = findNameForIsGetter;
        FIND_NAME_FOR_REGULAR_GETTER = findNameForRegularGetter;
        USE_REFLECTION_FOR_MEMBER_NAME = useReflectionForMemberName;
    }
}

