/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CreateTopicOptions {
    private final List<AuthorizationRule> authorizationRules;
    private Duration autoDeleteOnIdle;
    private Duration defaultMessageTimeToLive;
    private Duration duplicateDetectionHistoryTimeWindow;
    private boolean enableBatchedOperations;
    private boolean enablePartitioning;
    private Duration lockDuration;
    private int maxDeliveryCount;
    private long maxSizeInMegabytes;
    private boolean requiresDuplicateDetection;
    private boolean requiresSession;
    private EntityStatus status;
    private boolean supportOrdering;
    private String userMetadata;

    public CreateTopicOptions() {
        this.authorizationRules = new ArrayList<AuthorizationRule>();
        this.autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        this.defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        this.duplicateDetectionHistoryTimeWindow = ServiceBusConstants.DEFAULT_DUPLICATE_DETECTION_DURATION;
        this.enableBatchedOperations = true;
        this.enablePartitioning = false;
        this.lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        this.maxDeliveryCount = 10;
        this.maxSizeInMegabytes = 1024L;
        this.requiresDuplicateDetection = false;
        this.requiresSession = false;
        this.status = EntityStatus.ACTIVE;
    }

    public CreateTopicOptions(TopicProperties topic) {
        Objects.requireNonNull(topic, "'topic' cannot be null.");
        this.authorizationRules = new ArrayList<AuthorizationRule>(topic.getAuthorizationRules());
        this.autoDeleteOnIdle = topic.getAutoDeleteOnIdle();
        this.defaultMessageTimeToLive = topic.getDefaultMessageTimeToLive();
        this.duplicateDetectionHistoryTimeWindow = topic.getDuplicateDetectionHistoryTimeWindow();
        this.enableBatchedOperations = topic.isBatchedOperationsEnabled();
        this.enablePartitioning = topic.isPartitioningEnabled();
        this.maxSizeInMegabytes = topic.getMaxSizeInMegabytes();
        this.requiresDuplicateDetection = topic.isDuplicateDetectionRequired();
        this.supportOrdering = topic.isOrderingSupported();
        this.status = topic.getStatus();
        this.userMetadata = topic.getUserMetadata();
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public CreateTopicOptions setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public CreateTopicOptions setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public CreateTopicOptions setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public CreateTopicOptions setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Boolean isPartitioningEnabled() {
        return this.enablePartitioning;
    }

    public CreateTopicOptions setPartitioningEnabled(boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public CreateTopicOptions setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public boolean isSupportOrdering() {
        return this.supportOrdering;
    }

    public CreateTopicOptions setOrderingSupported(boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public CreateTopicOptions setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public CreateTopicOptions setMaxDeliveryCount(int maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public CreateTopicOptions setMaxSizeInMegabytes(long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Boolean isDuplicateDetectionRequired() {
        return this.requiresDuplicateDetection;
    }

    public CreateTopicOptions setDuplicateDetectionRequired(boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Boolean isSessionRequired() {
        return this.requiresSession;
    }

    public CreateTopicOptions setSessionRequired(boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public CreateTopicOptions setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }
}

