/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;

@ServiceClientBuilder(serviceClients={AzureFileStorageImpl.class})
public final class AzureFileStorageBuilder {
    private String version;
    private String url;
    private HttpPipeline pipeline;

    public AzureFileStorageBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureFileStorageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureFileStorageBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureFileStorageImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        AzureFileStorageImpl client = new AzureFileStorageImpl(this.pipeline);
        if (this.version != null) {
            client.setVersion(this.version);
        } else {
            client.setVersion("2019-07-07");
        }
        if (this.url != null) {
            client.setUrl(this.url);
        }
        return client;
    }
}

