/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DirectorysCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectorysDeleteResponse;
import com.azure.storage.file.share.implementation.models.DirectorysForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectorysGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectorysListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectorysListHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectorysSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectorysSetPropertiesResponse;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DirectorysImpl {
    private DirectorysService service;
    private AzureFileStorageImpl client;

    public DirectorysImpl(AzureFileStorageImpl client) {
        this.service = (DirectorysService)RestProxy.create(DirectorysService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<DirectorysCreateResponse> createWithRestResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String filePermission = null;
        String filePermissionKey = null;
        String restype = "directory";
        return this.service.create(shareName, directoryPath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "directory", context);
    }

    public Mono<DirectorysCreateResponse> createWithRestResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        return this.service.create(shareName, directoryPath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "directory", context);
    }

    public Mono<DirectorysGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String directoryPath, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String restype = "directory";
        return this.service.getProperties(shareName, directoryPath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), "directory", context);
    }

    public Mono<DirectorysGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String directoryPath, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        return this.service.getProperties(shareName, directoryPath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), "directory", context);
    }

    public Mono<DirectorysDeleteResponse> deleteWithRestResponseAsync(String shareName, String directoryPath, Context context) {
        Integer timeout = null;
        String restype = "directory";
        return this.service.delete(shareName, directoryPath, this.client.getUrl(), timeout, this.client.getVersion(), "directory", context);
    }

    public Mono<DirectorysDeleteResponse> deleteWithRestResponseAsync(String shareName, String directoryPath, Integer timeout, Context context) {
        String restype = "directory";
        return this.service.delete(shareName, directoryPath, this.client.getUrl(), timeout, this.client.getVersion(), "directory", context);
    }

    public Mono<DirectorysSetPropertiesResponse> setPropertiesWithRestResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        Integer timeout = null;
        String filePermission = null;
        String filePermissionKey = null;
        String restype = "directory";
        String comp = "properties";
        return this.service.setProperties(shareName, directoryPath, this.client.getUrl(), timeout, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "directory", "properties", context);
    }

    public Mono<DirectorysSetPropertiesResponse> setPropertiesWithRestResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        String comp = "properties";
        return this.service.setProperties(shareName, directoryPath, this.client.getUrl(), timeout, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "directory", "properties", context);
    }

    public Mono<DirectorysSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String directoryPath, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String restype = "directory";
        String comp = "metadata";
        return this.service.setMetadata(shareName, directoryPath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "directory", "metadata", context);
    }

    public Mono<DirectorysSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String directoryPath, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        return this.service.setMetadata(shareName, directoryPath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "directory", "metadata", context);
    }

    public Mono<DirectorysListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithRestResponseAsync(String shareName, String directoryPath, Context context) {
        String prefix = null;
        String sharesnapshot = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String restype = "directory";
        String comp = "list";
        return this.service.listFilesAndDirectoriesSegment(shareName, directoryPath, this.client.getUrl(), prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), "directory", "list", context);
    }

    public Mono<DirectorysListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithRestResponseAsync(String shareName, String directoryPath, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, Context context) {
        String restype = "directory";
        String comp = "list";
        return this.service.listFilesAndDirectoriesSegment(shareName, directoryPath, this.client.getUrl(), prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), "directory", "list", context);
    }

    public Mono<DirectorysListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String directoryPath, Context context) {
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String sharesnapshot = null;
        Boolean recursive = null;
        String comp = "listhandles";
        return this.service.listHandles(shareName, directoryPath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), "listhandles", context);
    }

    public Mono<DirectorysListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String directoryPath, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        return this.service.listHandles(shareName, directoryPath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), "listhandles", context);
    }

    public Mono<DirectorysForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String directoryPath, String handleId, Context context) {
        Integer timeout = null;
        String marker = null;
        String sharesnapshot = null;
        Boolean recursive = null;
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, directoryPath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), "forceclosehandles", context);
    }

    public Mono<DirectorysForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String directoryPath, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, directoryPath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), "forceclosehandles", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageDirectorys")
    private static interface DirectorysService {
        @Put(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysCreateResponse> create(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-permission") String var7, @HeaderParam(value="x-ms-file-permission-key") String var8, @HeaderParam(value="x-ms-file-attributes") String var9, @HeaderParam(value="x-ms-file-creation-time") String var10, @HeaderParam(value="x-ms-file-last-write-time") String var11, @QueryParam(value="restype") String var12, Context var13);

        @Get(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysGetPropertiesResponse> getProperties(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="restype") String var7, Context var8);

        @Delete(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysDeleteResponse> delete(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, Context var7);

        @Put(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysSetPropertiesResponse> setProperties(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-permission") String var6, @HeaderParam(value="x-ms-file-permission-key") String var7, @HeaderParam(value="x-ms-file-attributes") String var8, @HeaderParam(value="x-ms-file-creation-time") String var9, @HeaderParam(value="x-ms-file-last-write-time") String var10, @QueryParam(value="restype") String var11, @QueryParam(value="comp") String var12, Context var13);

        @Put(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysSetMetadataResponse> setMetadata(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Get(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegment(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="prefix") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="marker") String var6, @QueryParam(value="maxresults") Integer var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11, Context var12);

        @Get(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysListHandlesResponse> listHandles(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-recursive") Boolean var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="comp") String var10, Context var11);

        @Put(value="{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectorysForceCloseHandlesResponse> forceCloseHandles(@PathParam(value="shareName") String var1, @PathParam(value="directoryPath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="marker") String var5, @QueryParam(value="sharesnapshot") String var6, @HeaderParam(value="x-ms-handle-id") String var7, @HeaderParam(value="x-ms-recursive") Boolean var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="comp") String var10, Context var11);
    }
}

