/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.storage.file.share.implementation.models.DirectoryItem;
import com.azure.storage.file.share.implementation.models.FileItem;
import com.azure.storage.file.share.implementation.models.FilesAndDirectoriesListSegment;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;

final class CustomFileAndDirectoryListingDeserializer
extends JsonDeserializer<FilesAndDirectoriesListSegment> {
    CustomFileAndDirectoryListingDeserializer() {
    }

    public FilesAndDirectoriesListSegment deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<DirectoryItem> directoryItems = new ArrayList<DirectoryItem>();
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        JsonDeserializer directoryItemDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(DirectoryItem.class));
        JsonDeserializer fileItemDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(FileItem.class));
        JsonToken currentToken = p.nextToken();
        while (!currentToken.name().equals("END_OBJECT")) {
            p.nextToken();
            if (p.getCurrentName().equals("Directory")) {
                directoryItems.add((DirectoryItem)directoryItemDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("File")) {
                fileItems.add((FileItem)fileItemDeserializer.deserialize(p, ctxt));
            }
            currentToken = p.nextToken();
        }
        return new FilesAndDirectoriesListSegment().setDirectoryItems(directoryItems).setFileItems(fileItems);
    }
}

