/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="File-GetProperties-Headers")
public final class FileGetPropertiesHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="x-ms-type")
    private String fileType;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-file-attributes")
    private String fileAttributes;
    @JsonProperty(value="x-ms-file-creation-time")
    private OffsetDateTime fileCreationTime;
    @JsonProperty(value="x-ms-file-last-write-time")
    private OffsetDateTime fileLastWriteTime;
    @JsonProperty(value="x-ms-file-change-time")
    private OffsetDateTime fileChangeTime;
    @JsonProperty(value="x-ms-file-permission-key")
    private String filePermissionKey;
    @JsonProperty(value="x-ms-file-id")
    private String fileId;
    @JsonProperty(value="x-ms-file-parent-id")
    private String fileParentId;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FileGetPropertiesHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getFileType() {
        return this.fileType;
    }

    public FileGetPropertiesHeaders setFileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public FileGetPropertiesHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public FileGetPropertiesHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FileGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public FileGetPropertiesHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public FileGetPropertiesHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public FileGetPropertiesHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public FileGetPropertiesHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public FileGetPropertiesHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public FileGetPropertiesHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public FileGetPropertiesHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public FileGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public FileGetPropertiesHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public FileGetPropertiesHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public FileGetPropertiesHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public FileGetPropertiesHeaders setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public FileGetPropertiesHeaders setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public FileGetPropertiesHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public FileGetPropertiesHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String getFileAttributes() {
        return this.fileAttributes;
    }

    public FileGetPropertiesHeaders setFileAttributes(String fileAttributes) {
        this.fileAttributes = fileAttributes;
        return this;
    }

    public OffsetDateTime getFileCreationTime() {
        return this.fileCreationTime;
    }

    public FileGetPropertiesHeaders setFileCreationTime(OffsetDateTime fileCreationTime) {
        this.fileCreationTime = fileCreationTime;
        return this;
    }

    public OffsetDateTime getFileLastWriteTime() {
        return this.fileLastWriteTime;
    }

    public FileGetPropertiesHeaders setFileLastWriteTime(OffsetDateTime fileLastWriteTime) {
        this.fileLastWriteTime = fileLastWriteTime;
        return this;
    }

    public OffsetDateTime getFileChangeTime() {
        return this.fileChangeTime;
    }

    public FileGetPropertiesHeaders setFileChangeTime(OffsetDateTime fileChangeTime) {
        this.fileChangeTime = fileChangeTime;
        return this;
    }

    public String getFilePermissionKey() {
        return this.filePermissionKey;
    }

    public FileGetPropertiesHeaders setFilePermissionKey(String filePermissionKey) {
        this.filePermissionKey = filePermissionKey;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public FileGetPropertiesHeaders setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getFileParentId() {
        return this.fileParentId;
    }

    public FileGetPropertiesHeaders setFileParentId(String fileParentId) {
        this.fileParentId = fileParentId;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public FileGetPropertiesHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public FileGetPropertiesHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public FileGetPropertiesHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public FileGetPropertiesHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

