/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.CopyStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="File-StartCopy-Headers")
public final class FileStartCopyHeaders {
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String getETag() {
        return this.eTag;
    }

    public FileStartCopyHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileStartCopyHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public FileStartCopyHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public FileStartCopyHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public FileStartCopyHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public FileStartCopyHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public FileStartCopyHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public FileStartCopyHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

