/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Share-GetProperties-Headers")
public final class ShareGetPropertiesHeaders {
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-share-quota")
    private Integer quota;
    @JsonProperty(value="x-ms-share-provisioned-iops")
    private Integer provisionedIops;
    @JsonProperty(value="x-ms-share-provisioned-ingress-mbps")
    private Integer provisionedIngressMBps;
    @JsonProperty(value="x-ms-share-provisioned-egress-mbps")
    private Integer provisionedEgressMBps;
    @JsonProperty(value="x-ms-share-next-allowed-quota-downgrade-time")
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-access-tier")
    private String accessTier;
    @JsonProperty(value="x-ms-access-tier-change-time")
    private DateTimeRfc1123 accessTierChangeTime;
    @JsonProperty(value="x-ms-access-tier-transition-state")
    private String accessTierTransitionState;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareGetPropertiesHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ShareGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ShareGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ShareGetPropertiesHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ShareGetPropertiesHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public ShareGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public ShareGetPropertiesHeaders setQuota(Integer quota) {
        this.quota = quota;
        return this;
    }

    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    public ShareGetPropertiesHeaders setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    public ShareGetPropertiesHeaders setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    public ShareGetPropertiesHeaders setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public ShareGetPropertiesHeaders setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        this.nextAllowedQuotaDowngradeTime = nextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public ShareGetPropertiesHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public ShareGetPropertiesHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public ShareGetPropertiesHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public ShareGetPropertiesHeaders setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public ShareGetPropertiesHeaders setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    public ShareGetPropertiesHeaders setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ShareGetPropertiesHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

