/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import java.util.EnumSet;

public enum NtfsFileAttributes {
    READ_ONLY,
    HIDDEN,
    SYSTEM,
    NORMAL,
    DIRECTORY,
    ARCHIVE,
    TEMPORARY,
    OFFLINE,
    NOT_CONTENT_INDEXED,
    NO_SCRUB_DATA;


    public static String toString(EnumSet<NtfsFileAttributes> ntfsAttributes) {
        if (ntfsAttributes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, READ_ONLY, "ReadOnly|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, HIDDEN, "Hidden|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, SYSTEM, "System|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NORMAL, "None|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, DIRECTORY, "Directory|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, ARCHIVE, "Archive|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, TEMPORARY, "Temporary|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, OFFLINE, "Offline|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NOT_CONTENT_INDEXED, "NotContentIndexed|");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NO_SCRUB_DATA, "NoScrubData|");
        builder.deleteCharAt(builder.lastIndexOf("|"));
        return builder.toString();
    }

    private static void toStringHelper(StringBuilder sb, EnumSet<NtfsFileAttributes> ntfsAttributes, NtfsFileAttributes attributes, String toAdd) {
        if (ntfsAttributes.contains((Object)attributes)) {
            sb.append(toAdd);
        }
    }

    public static EnumSet<NtfsFileAttributes> toAttributes(String ntfsAttributes) {
        String[] splitAttributes;
        if (ntfsAttributes == null) {
            return null;
        }
        EnumSet<NtfsFileAttributes> attributes = EnumSet.noneOf(NtfsFileAttributes.class);
        for (String sa : splitAttributes = ntfsAttributes.split("\\|")) {
            if ((sa = sa.trim()).equals("ReadOnly")) {
                attributes.add(READ_ONLY);
                continue;
            }
            if (sa.equals("Hidden")) {
                attributes.add(HIDDEN);
                continue;
            }
            if (sa.equals("System")) {
                attributes.add(SYSTEM);
                continue;
            }
            if (sa.equals("None")) {
                attributes.add(NORMAL);
                continue;
            }
            if (sa.equals("Directory")) {
                attributes.add(DIRECTORY);
                continue;
            }
            if (sa.equals("Archive")) {
                attributes.add(ARCHIVE);
                continue;
            }
            if (sa.equals("Temporary")) {
                attributes.add(TEMPORARY);
                continue;
            }
            if (sa.equals("Offline")) {
                attributes.add(OFFLINE);
                continue;
            }
            if (sa.equals("NotContentIndexed")) {
                attributes.add(NOT_CONTENT_INDEXED);
                continue;
            }
            if (sa.equals("NoScrubData")) {
                attributes.add(NO_SCRUB_DATA);
                continue;
            }
            throw new IllegalArgumentException("FileAttribute '" + sa + "' not recognized.");
        }
        return attributes;
    }
}

