/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.sas;

import com.azure.core.util.CoreUtils;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.azure.storage.file.share.sas.ShareSasPermission;
import com.azure.storage.file.share.sas.ShareServiceSasQueryParameters;
import java.time.OffsetDateTime;

public final class ShareServiceSasSignatureValues {
    private static final String SAS_FILE_CONSTANT = "f";
    private static final String SAS_SHARE_CONSTANT = "s";
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String shareName;
    private String filePath;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    @Deprecated
    public ShareServiceSasSignatureValues() {
    }

    public ShareServiceSasSignatureValues(OffsetDateTime expiryTime, ShareSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public ShareServiceSasSignatureValues(OffsetDateTime expiryTime, ShareFileSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public ShareServiceSasSignatureValues(String identifier) {
        StorageImplUtils.assertNotNull((String)"identifier", (Object)identifier);
        this.identifier = identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public ShareServiceSasSignatureValues setVersion(String version) {
        this.version = version;
        return this;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public ShareServiceSasSignatureValues setProtocol(SasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public ShareServiceSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public ShareServiceSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public ShareServiceSasSignatureValues setPermissions(ShareSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public ShareServiceSasSignatureValues setPermissions(ShareFileSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public ShareServiceSasSignatureValues setSasIpRange(SasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    @Deprecated
    public String getShareName() {
        return this.shareName;
    }

    @Deprecated
    public ShareServiceSasSignatureValues setShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    @Deprecated
    public String getFilePath() {
        return this.filePath;
    }

    @Deprecated
    public ShareServiceSasSignatureValues setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ShareServiceSasSignatureValues setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public ShareServiceSasSignatureValues setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public ShareServiceSasSignatureValues setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public ShareServiceSasSignatureValues setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public ShareServiceSasSignatureValues setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ShareServiceSasSignatureValues setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Deprecated
    public ShareServiceSasQueryParameters generateSasQueryParameters(StorageSharedKeyCredential storageSharedKeyCredentials) {
        String resource;
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        if (CoreUtils.isNullOrEmpty((CharSequence)this.filePath)) {
            resource = SAS_SHARE_CONSTANT;
            if (this.permissions != null) {
                this.permissions = ShareSasPermission.parse(this.permissions).toString();
            }
        } else {
            resource = SAS_FILE_CONSTANT;
            if (this.permissions != null) {
                this.permissions = ShareFileSasPermission.parse(this.permissions).toString();
            }
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)this.version)) {
            this.version = ShareServiceVersion.getLatest().getVersion();
        }
        String canonicalName = ShareServiceSasSignatureValues.getCanonicalName(storageSharedKeyCredentials.getAccountName(), this.shareName, this.filePath);
        String stringToSign = this.stringToSign(canonicalName);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return new ShareServiceSasQueryParameters(this.version, this.protocol, this.startTime, this.expiryTime, this.sasIpRange, this.identifier, resource, this.permissions, signature, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType);
    }

    private static String getCanonicalName(String account, String shareName, String filePath) {
        return !CoreUtils.isNullOrEmpty((CharSequence)filePath) ? String.format("/file/%s/%s/%s", account, shareName, filePath.replace("\\", "/")) : String.format("/file/%s/%s", account, shareName);
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

