/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.DynamicGroupDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    protected Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    protected Map<String, DynamicGroupDataSource> groupDataSources = new HashMap<String, DynamicGroupDataSource>();
    protected DynamicDataSourceProvider provider;
    protected Class<? extends DynamicDataSourceStrategy> strategy;
    protected String primary;

    @Override
    public DataSource determineDataSource() {
        String lookupKey = DynamicDataSourceContextHolder.getDataSourceLookupKey();
        if (StringUtils.isEmpty((Object)lookupKey)) {
            return this.determinePrimaryDataSource();
        }
        if (this.groupDataSources.containsKey(lookupKey) && !this.groupDataSources.isEmpty()) {
            log.debug("\u4ece {} \u7ec4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)lookupKey);
            return this.groupDataSources.get(lookupKey).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(lookupKey)) {
            log.debug("\u4ece {} \u5355\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)lookupKey);
            return this.dataSourceMap.get(lookupKey);
        }
        return this.determinePrimaryDataSource();
    }

    private DataSource determinePrimaryDataSource() {
        log.debug("\u4ece\u9ed8\u8ba4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e");
        return this.groupDataSources.containsKey(this.primary) ? this.groupDataSources.get(this.primary).determineDataSource() : this.dataSourceMap.get(this.primary);
    }

    public synchronized void addDataSource(String dsName, DataSource dataSource) {
        this.dataSourceMap.put(dsName, dataSource);
        if (dsName.contains("_")) {
            String groupName = dsName.split("_")[0];
            if (this.groupDataSources.containsKey(groupName)) {
                this.groupDataSources.get(groupName).addDatasource(dataSource);
            } else {
                try {
                    DynamicGroupDataSource groupDatasource = new DynamicGroupDataSource(groupName, this.strategy.newInstance());
                    groupDatasource.addDatasource(dataSource);
                    this.groupDataSources.put(groupName, groupDatasource);
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
                    this.dataSourceMap.remove(dsName);
                }
            }
        }
        log.info("\u6dfb\u52a0\u6570\u636e\u6e90 {} \u6210\u529f", (Object)dsName);
    }

    public synchronized void removeDataSource(String dsName, DataSource dataSource) {
        String groupName;
        this.dataSourceMap.remove(dataSource);
        if (dsName.contains("_") && this.groupDataSources.containsKey(groupName = dsName.split("_")[0])) {
            this.groupDataSources.get(groupName).removeDatasource(dataSource);
        }
        log.info("\u5220\u9664\u6570\u636e\u6e90 {} \u6210\u529f", (Object)dsName);
    }

    public void afterPropertiesSet() {
        Map<String, DataSource> dataSources = this.provider.loadDataSources();
        log.info("\u521d\u59cb\u5171\u52a0\u8f7d {} \u4e2a\u6570\u636e\u6e90", (Object)dataSources.size());
        for (Map.Entry<String, DataSource> dsItem : dataSources.entrySet()) {
            this.addDataSource(dsItem.getKey(), dsItem.getValue());
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u7ec4\u6570\u636e\u6e90,\u7ec4\u540d\u4e3a {} \uff0c\u5176\u4e0b\u6709 {} \u4e2a\u6570\u636e\u6e90", (Object)this.primary, (Object)this.groupDataSources.size());
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u5355\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u540d\u4e3a{}", (Object)this.primary);
        } else {
            throw new RuntimeException("\u8bf7\u68c0\u67e5primary\u9ed8\u8ba4\u6570\u636e\u5e93\u8bbe\u7f6e\uff0c\u5f53\u524d\u672a\u627e\u5230" + this.primary + "\u6570\u636e\u6e90");
        }
    }

    public void setProvider(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }

    public void setStrategy(Class<? extends DynamicDataSourceStrategy> strategy) {
        this.strategy = strategy;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }
}

