/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class DynamicDataSourceSpelParser {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    @Autowired
    private HttpSession session;
    @Autowired
    private HttpServletRequest request;

    public String parse(MethodInvocation invocation, String key) {
        if (key.startsWith("#session")) {
            return this.session.getAttribute(key).toString();
        }
        if (key.startsWith("#header")) {
            return this.request.getHeader(key);
        }
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, invocation.getMethod(), invocation.getArguments(), NAME_DISCOVERER);
        return PARSER.parseExpression(key).getValue((EvaluationContext)context).toString();
    }
}

