/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.spi;

import com.baomidou.mybatisplus.core.toolkit.AopUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.spi.CompatibleSet;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionHolder;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringCompatibleSet
implements CompatibleSet {
    private static final Log LOG = LogFactory.getLog(SpringCompatibleSet.class);
    public static volatile ApplicationContext applicationContext;

    public SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)sessionFactory);
    }

    public void closeSqlSession(SqlSession sqlSession, SqlSessionFactory sqlSessionFactory) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeBatch(SqlSessionFactory sqlSessionFactory, Log log, Consumer<SqlSession> consumer) {
        SqlSession sqlSession;
        SqlSessionHolder sqlSessionHolder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sqlSessionFactory);
        boolean transaction = TransactionSynchronizationManager.isSynchronizationActive();
        if (sqlSessionHolder != null) {
            sqlSession = sqlSessionHolder.getSqlSession();
            sqlSession.commit(!transaction);
        }
        sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + sqlSession + "] Transaction not enabled");
        }
        try {
            consumer.accept(sqlSession);
            sqlSession.commit(!transaction);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
            if (!(unwrapped instanceof PersistenceException)) throw ExceptionUtils.mpe((Throwable)unwrapped);
            MyBatisExceptionTranslator myBatisExceptionTranslator = new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
            DataAccessException throwable = myBatisExceptionTranslator.translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped));
            if (throwable == null) throw ExceptionUtils.mpe((Throwable)unwrapped);
            throw throwable;
        }
        finally {
            sqlSession.close();
        }
    }

    public InputStream getInputStream(String path) throws Exception {
        return new ClassPathResource(path).getInputStream();
    }

    public <T> T getBean(Class<T> clz) {
        if (applicationContext != null) {
            ObjectProvider provider = applicationContext.getBeanProvider(clz);
            return (T)provider.getIfAvailable();
        }
        LOG.warn("The applicationContext property is empty. Please initialize it via the static field of applicationContext in SpringContextHolder or by calling the setApplicationContext method of MybatisSqlSessionFactoryBean.");
        return null;
    }

    public Object getProxyTargetObject(Object mapper) {
        Object result = mapper;
        if (AopUtils.isLoadSpringAop()) {
            while (org.springframework.aop.support.AopUtils.isAopProxy((Object)result)) {
                result = AopProxyUtils.getSingletonTarget((Object)result);
            }
        }
        return result;
    }

    public void setContext(Object context) {
        applicationContext = (ApplicationContext)context;
    }
}

