/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.build.HideRowColumnBuilder;
import com.bstek.ureport.build.Splash;
import com.bstek.ureport.build.cell.CellBuilder;
import com.bstek.ureport.build.cell.NoneExpandBuilder;
import com.bstek.ureport.build.cell.down.DownExpandBuilder;
import com.bstek.ureport.build.cell.right.RightExpandBuilder;
import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.BuildinDatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceProvider;
import com.bstek.ureport.definition.datasource.JdbcDatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReportBuilder
extends BasePagination
implements ApplicationContextAware {
    public static final String BEAN_ID = "ureport.reportBuilder";
    private static final Logger log = Logger.getGlobal();
    private ApplicationContext applicationContext;
    private Map<String, DatasourceProvider> datasourceProviderMap = new HashMap<String, DatasourceProvider>();
    private Map<Expand, CellBuilder> cellBuildersMap = new HashMap<Expand, CellBuilder>();
    private NoneExpandBuilder noneExpandBuilder = new NoneExpandBuilder();
    private HideRowColumnBuilder hideRowColumnBuilder;

    public ReportBuilder() {
        this.cellBuildersMap.put(Expand.Right, new RightExpandBuilder());
        this.cellBuildersMap.put(Expand.Down, new DownExpandBuilder());
        this.cellBuildersMap.put(Expand.None, this.noneExpandBuilder);
    }

    public Report buildReport(ReportDefinition reportDefinition, Map<String, Object> parameters) {
        Report report = reportDefinition.newReport();
        Map<String, Dataset> datasetMap = this.buildDatasets(reportDefinition, parameters, this.applicationContext);
        Context context = new Context(this, report, datasetMap, this.applicationContext, parameters, this.hideRowColumnBuilder);
        long start = System.currentTimeMillis();
        List<Cell> cells = new ArrayList<Cell>();
        cells.add(report.getRootCell());
        do {
            this.buildCell(context, cells);
        } while ((cells = context.nextUnprocessedCells()) != null);
        this.doFillBlankRows(report, context);
        this.recomputeCells(report, context);
        long end = System.currentTimeMillis();
        log.info("Report compute completed:" + (end - start) + "ms");
        return report;
    }

    public void buildCell(Context context, List<Cell> cells) {
        if (cells == null) {
            cells = context.nextUnprocessedCells();
        }
        if (cells == null) {
            return;
        }
        for (Cell cell : cells) {
            int result;
            List<BindData> dataList = context.buildCellData(cell);
            cell.setProcessed(true);
            int size = dataList.size();
            Cell lastCell = cell;
            if (size == 1) {
                lastCell = this.noneExpandBuilder.buildCell(dataList, cell, context);
            } else if (size > 1) {
                CellBuilder cellBuilder = this.cellBuildersMap.get(cell.getExpand());
                lastCell = cellBuilder.buildCell(dataList, cell, context);
            }
            if (!lastCell.isFillBlankRows() || lastCell.getMultiple() <= 0 || (result = size % lastCell.getMultiple()) <= 0) continue;
            int value = lastCell.getMultiple() - result;
            context.addFillBlankRow(lastCell.getRow(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Dataset> buildDatasets(ReportDefinition reportDefinition, Map<String, Object> parameters, ApplicationContext applicationContext) {
        HashMap<String, Dataset> datasetMap = new HashMap<String, Dataset>();
        List<DatasourceDefinition> datasources = reportDefinition.getDatasources();
        if (datasources == null) {
            return datasetMap;
        }
        for (DatasourceDefinition dsDef : datasources) {
            Object ds2;
            List<Dataset> ls;
            Connection conn;
            String dsName;
            if (dsDef instanceof JdbcDatasourceDefinition) {
                dsName = dsDef.getName();
                conn = null;
                try {
                    if (this.datasourceProviderMap.containsKey(dsName)) {
                        conn = this.datasourceProviderMap.get(dsName).getConnection();
                    }
                    if ((ls = ((JdbcDatasourceDefinition)(ds2 = (JdbcDatasourceDefinition)dsDef)).buildDatasets(conn, parameters)) == null) continue;
                    for (Dataset dataset : ls) {
                        datasetMap.put(dataset.getName(), dataset);
                    }
                    continue;
                }
                finally {
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (SQLException ds2) {}
                    continue;
                }
            }
            if (dsDef instanceof SpringBeanDatasourceDefinition) {
                SpringBeanDatasourceDefinition ds3 = (SpringBeanDatasourceDefinition)dsDef;
                List<Dataset> ls2 = ds3.getDatasets(applicationContext, parameters);
                if (ls2 == null) continue;
                ds2 = ls2.iterator();
                while (ds2.hasNext()) {
                    Dataset dataset = (Dataset)((Object)ds2.next());
                    datasetMap.put(dataset.getName(), dataset);
                }
                continue;
            }
            if (!(dsDef instanceof BuildinDatasourceDefinition)) continue;
            dsName = dsDef.getName();
            conn = null;
            try {
                if (this.datasourceProviderMap.containsKey(dsName)) {
                    conn = this.datasourceProviderMap.get(dsName).getConnection();
                }
                for (BuildinDatasource datasource : Utils.getBuildinDatasources()) {
                    if (!datasource.name().equals(dsName)) continue;
                    conn = datasource.getConnection();
                    break;
                }
                if (conn == null) {
                    throw new ReportComputeException("Buildin datasource [" + dsName + "] not exist.");
                }
                ds2 = (BuildinDatasourceDefinition)dsDef;
                ls = ((BuildinDatasourceDefinition)ds2).buildDatasets(conn, parameters);
                if (ls == null) continue;
                for (Dataset dataset : ls) {
                    datasetMap.put(dataset.getName(), dataset);
                }
            }
            finally {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return datasetMap;
    }

    private void doFillBlankRows(Report report, Context context) {
        Map<Row, Integer> map = context.getFillBlankRowsMap();
        ArrayList<Row> newRowList = new ArrayList<Row>();
        for (Row row : map.keySet()) {
            int size = map.get(row);
            Row lastRow = this.findLastRow(row, report);
            for (int i = 0; i < size; ++i) {
                Row newRow = this.buildNewRow(lastRow, report);
                newRowList.add(newRow);
            }
            int rowNumber = lastRow.getRowNumber();
            if (newRowList.size() <= 0) continue;
            report.insertRows(rowNumber + 1, newRowList);
            newRowList.clear();
        }
    }

    private Row buildNewRow(Row row, Report report) {
        Row newRow = row.newRow();
        newRow.setBand(null);
        List<Row> rows = report.getRows();
        List<Column> columns = report.getColumns();
        int start = -1;
        int colSize = columns.size();
        Map<Row, Map<Column, Cell>> rowMap = report.getRowColCellMap();
        HashMap<Column, Cell> newCellMap = new HashMap<Column, Cell>();
        rowMap.put(newRow, newCellMap);
        Map<Column, Cell> colMap = rowMap.get(row);
        for (int index = 0; index < colSize; ++index) {
            int rowSpan;
            Column column = columns.get(index);
            Cell currentCell = colMap.get(column);
            if (currentCell == null) {
                if (start == -1) {
                    start = row.getRowNumber() - 2;
                }
                for (int i = start; i > -1; --i) {
                    Row currentRow = rows.get(i);
                    Map<Column, Cell> prevColMap = rowMap.get(currentRow);
                    if (!prevColMap.containsKey(column)) continue;
                    currentCell = prevColMap.get(column);
                    break;
                }
            }
            if (currentCell == null) {
                throw new ReportException("Insert blank rows fail.");
            }
            int colSpan = currentCell.getColSpan();
            if (colSpan > 0) {
                index += --colSpan;
            }
            if ((rowSpan = currentCell.getRowSpan()) > 1) {
                currentCell.setRowSpan(rowSpan + 1);
                continue;
            }
            Cell newCell = this.newBlankCell(currentCell, column, report);
            newCell.setRow(newRow);
            newRow.getCells().add(newCell);
            newCellMap.put(newCell.getColumn(), newCell);
        }
        return newRow;
    }

    private Row findLastRow(Row row, Report report) {
        List<Row> rows = report.getRows();
        List<Cell> cells = row.getCells();
        Row lastRow = row;
        int span = 0;
        for (Cell cell : cells) {
            int rowSpan = cell.getRowSpan();
            if (rowSpan < 2) continue;
            if (span == 0) {
                span = rowSpan;
                continue;
            }
            if (rowSpan <= span) continue;
            span = rowSpan;
        }
        if (span > 1) {
            int rowIndex = row.getRowNumber() - 1 + span - 1;
            lastRow = rows.get(rowIndex);
        }
        return lastRow;
    }

    private Cell newBlankCell(Cell cell, Column column, Report report) {
        Cell topParent;
        Cell newCell = new Cell();
        newCell.setData("");
        newCell.setColSpan(cell.getColSpan());
        newCell.setConditionPropertyItems(cell.getConditionPropertyItems());
        report.addLazyCell(newCell);
        newCell.setCellStyle(cell.getCellStyle());
        newCell.setName(cell.getName());
        newCell.setColumn(column);
        column.getCells().add(newCell);
        Cell leftParent = cell.getLeftParentCell();
        if (leftParent != null) {
            newCell.setLeftParentCell(leftParent);
            leftParent.addRowChild(newCell);
        }
        if ((topParent = cell.getTopParentCell()) != null) {
            newCell.setTopParentCell(topParent);
            topParent.addColumnChild(newCell);
        }
        return newCell;
    }

    private void recomputeCells(Report report, Context context) {
        List<Cell> lazyCells = report.getLazyComputeCells();
        for (Cell cell : lazyCells) {
            cell.doCompute(context);
        }
        context.setDoPaging(true);
        List<Row> rows = report.getRows();
        int rowSize = rows.size();
        Paper paper = report.getPaper();
        PagingMode pagingMode = paper.getPagingMode();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        List<Row> titleRows = report.getTitleRows();
        List<Row> summaryRows = report.getSummaryRows();
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        int pageIndex = 1;
        ArrayList<Row> pageRepeatHeaders = new ArrayList<Row>();
        ArrayList<Row> pageRepeatFooters = new ArrayList<Row>();
        pageRepeatHeaders.addAll(headerRows);
        pageRepeatFooters.addAll(footerRows);
        if (pagingMode.equals(PagingMode.fitpage)) {
            int height = paper.getHeight() - paper.getBottomMargin() - paper.getTopMargin() - 5;
            if (paper.getOrientation().equals(Orientation.landscape)) {
                height = paper.getWidth() - paper.getBottomMargin() - paper.getTopMargin() - 5;
            }
            int repeatHeaderRowHeight = report.getRepeatHeaderRowHeight();
            int repeatFooterRowHeight = report.getRepeatFooterRowHeight();
            int titleRowHeight = report.getTitleRowsHeight();
            int rowHeight = titleRowHeight + repeatHeaderRowHeight + repeatFooterRowHeight;
            for (int i = 0; i < rowSize; ++i) {
                Row nextRow;
                Row row = rows.get(i);
                int rowRealHeight = row.getRealHeight();
                if (rowRealHeight == 0) continue;
                Band band = row.getBand();
                if (band != null) {
                    int j;
                    String rowKey = row.getRowKey();
                    int index = -1;
                    if (band.equals((Object)Band.headerrepeat)) {
                        for (j = 0; j < pageRepeatHeaders.size(); ++j) {
                            Row headerRow = (Row)pageRepeatHeaders.get(j);
                            if (!headerRow.getRowKey().equals(rowKey)) continue;
                            index = j;
                            break;
                        }
                        pageRepeatHeaders.remove(index);
                        pageRepeatHeaders.add(index, row);
                        continue;
                    }
                    if (!band.equals((Object)Band.footerrepeat)) continue;
                    for (j = 0; j < pageRepeatFooters.size(); ++j) {
                        Row footerRow = (Row)pageRepeatFooters.get(j);
                        if (!footerRow.getRowKey().equals(rowKey)) continue;
                        index = j;
                        break;
                    }
                    pageRepeatFooters.remove(index);
                    pageRepeatFooters.add(index, row);
                    continue;
                }
                pageRows.add(row);
                boolean overflow = false;
                if (i + 1 < rows.size() && (rowHeight += rowRealHeight + 1) + (nextRow = rows.get(i + 1)).getRealHeight() > height) {
                    overflow = true;
                }
                if (!overflow && row.isPageBreak()) {
                    overflow = true;
                }
                if (!overflow) continue;
                Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
                ++pageIndex;
                pages.add(newPage);
                rowHeight = repeatHeaderRowHeight + repeatFooterRowHeight;
                pageRows = new ArrayList();
            }
            if (pageRows.size() > 0) {
                Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
                pages.add(newPage);
            }
            this.buildPageHeaderFooter(pages, report);
        } else {
            int fixRows = paper.getFixRows() - headerRows.size() - footerRows.size();
            if (fixRows < 0) {
                fixRows = 1;
            }
            for (int i = 0; i < rowSize; ++i) {
                Row row = rows.get(i);
                int height = row.getRealHeight();
                if (height == 0) continue;
                Band band = row.getBand();
                if (band != null) {
                    int j;
                    String rowKey = row.getRowKey();
                    int index = -1;
                    if (band.equals((Object)Band.headerrepeat)) {
                        for (j = 0; j < pageRepeatHeaders.size(); ++j) {
                            Row headerRow = (Row)pageRepeatHeaders.get(j);
                            if (!headerRow.getRowKey().equals(rowKey)) continue;
                            index = j;
                            break;
                        }
                        pageRepeatHeaders.remove(index);
                        pageRepeatHeaders.add(index, row);
                        continue;
                    }
                    if (!band.equals((Object)Band.footerrepeat)) continue;
                    for (j = 0; j < pageRepeatFooters.size(); ++j) {
                        Row footerRow = (Row)pageRepeatFooters.get(j);
                        if (!footerRow.getRowKey().equals(rowKey)) continue;
                        index = j;
                        break;
                    }
                    pageRepeatFooters.remove(index);
                    pageRepeatFooters.add(index, row);
                    continue;
                }
                pageRows.add(row);
                if (pageRows.size() + footerRows.size() < fixRows) continue;
                Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
                ++pageIndex;
                pages.add(newPage);
                pageRows = new ArrayList();
            }
            if (pageRows.size() > 0) {
                Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
                pages.add(newPage);
            }
            this.buildPageHeaderFooter(pages, report);
        }
        this.buildSummaryRows(summaryRows, pages);
        report.setPages(pages);
    }

    public void setHideRowColumnBuilder(HideRowColumnBuilder hideRowColumnBuilder) {
        this.hideRowColumnBuilder = hideRowColumnBuilder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Collection datasourceProviders = applicationContext.getBeansOfType(DatasourceProvider.class).values();
        for (DatasourceProvider dp : datasourceProviders) {
            this.datasourceProviderMap.put(dp.getName(), dp);
        }
        new Splash().doPrint();
    }
}

