/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.aggregate;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupAggregate
extends Aggregate {
    @Override
    public List<BindData> aggregate(DatasetExpression expr, Cell cell, Context context) {
        List<?> objList = DataUtils.fetchData(cell, context, expr.getDatasetName());
        List<BindData> list = this.doAggregate(expr, cell, context, objList);
        return list;
    }

    protected List<BindData> doAggregate(DatasetExpression expr, Cell cell, Context context, List<?> objList) {
        String property = expr.getProperty();
        Map<String, String> mappingMap = context.getMapping(expr);
        ArrayList<BindData> list = new ArrayList<BindData>();
        if (objList.size() == 0) {
            list.add(new BindData(""));
            return list;
        }
        if (objList.size() == 1) {
            Object o = objList.get(0);
            boolean conditionResult = this.doCondition(expr.getCondition(), cell, o, context);
            if (!conditionResult) {
                list.add(new BindData(""));
                return list;
            }
            Object data = Utils.getProperty(o, property);
            Object mappingData = this.mappingData(mappingMap, data);
            ArrayList<Object> rowList = new ArrayList<Object>();
            rowList.add(o);
            if (mappingData == null) {
                list.add(new BindData(data, rowList));
            } else {
                list.add(new BindData(data, mappingData, rowList));
            }
            return list;
        }
        HashMap<Object, List<Object>> map = new HashMap<Object, List<Object>>();
        for (Object o : objList) {
            boolean conditionResult = this.doCondition(expr.getCondition(), cell, o, context);
            if (!conditionResult) continue;
            Object data = Utils.getProperty(o, property);
            Object mappingData = this.mappingData(mappingMap, data);
            List<Object> rowList = null;
            if (map.containsKey(data)) {
                rowList = (List)map.get(data);
            } else {
                rowList = new ArrayList();
                map.put(data, rowList);
                if (mappingData == null) {
                    list.add(new BindData(data, rowList));
                } else {
                    list.add(new BindData(data, mappingData, rowList));
                }
            }
            rowList.add(o);
        }
        if (list.size() == 0) {
            ArrayList<Object> rowList = new ArrayList<Object>();
            rowList.add(new HashMap());
            list.add(new BindData("", rowList));
        }
        if (list.size() > 1) {
            Order order = expr.getOrder();
            this.orderBindDataList(list, order);
        }
        return list;
    }
}

