/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.aggregate;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class MaxAggregate
extends Aggregate {
    @Override
    public List<BindData> aggregate(DatasetExpression expr, Cell cell, Context context) {
        List<Object> list;
        String datasetName = expr.getDatasetName();
        String property = expr.getProperty();
        Cell leftCell = DataUtils.fetchLeftCell(cell, context, datasetName);
        Cell topCell = DataUtils.fetchTopCell(cell, context, datasetName);
        List<Object> leftList = null;
        List<Object> topList = null;
        if (leftCell != null) {
            leftList = leftCell.getBindData();
        }
        if (topCell != null) {
            topList = topCell.getBindData();
        }
        BigDecimal result = null;
        if (leftList == null && topList == null) {
            List<?> data = context.getDatasetData(datasetName);
            result = this.buildMax(data, property, cell, expr, context);
        } else if (leftList == null) {
            result = this.buildMax(topList, property, cell, expr, context);
        } else if (topList == null) {
            result = this.buildMax(leftList, property, cell, expr, context);
        } else {
            DatasetExpression de;
            Value value;
            list = null;
            Object data = null;
            String prop = null;
            if (leftList.size() > topList.size()) {
                list = topList;
                data = leftCell.getData();
                value = leftCell.getValue();
                de = DataUtils.fetchDatasetExpression(value);
                if (de == null) {
                    throw new ReportComputeException("Unsupport value : " + value);
                }
                prop = de.getProperty();
            } else {
                list = leftList;
                data = topCell.getData();
                value = topCell.getValue();
                de = DataUtils.fetchDatasetExpression(value);
                if (de == null) {
                    throw new ReportComputeException("Unsupport value : " + value);
                }
                prop = de.getProperty();
            }
            Condition condition = this.getCondition(cell);
            if (condition == null) {
                condition = expr.getCondition();
            }
            for (Object obj : list) {
                Object value2;
                Object o;
                if (condition != null && !condition.filter(cell, cell, obj, context) || ((o = Utils.getProperty(obj, prop)) == null || data == null || o != data && !o.equals(data)) && (o != null || data != null) || (value2 = Utils.getProperty(obj, property)) == null || value2.toString().equals("")) continue;
                BigDecimal b = Utils.toBigDecimal(value2);
                if (result == null) {
                    result = b;
                    continue;
                }
                int v = result.compareTo(b);
                if (v != -1) continue;
                result = b;
            }
        }
        list = new ArrayList();
        if (result != null) {
            list.add(new BindData(result.doubleValue(), null));
        } else {
            list.add(new BindData(0, null));
        }
        return list;
    }

    private BigDecimal buildMax(List<?> list, String property, Cell cell, DatasetExpression expr, Context context) {
        BigDecimal result = null;
        Condition condition = this.getCondition(cell);
        if (condition == null) {
            condition = expr.getCondition();
        }
        for (Object obj : list) {
            Object value;
            if (condition != null && !condition.filter(cell, cell, obj, context) || (value = Utils.getProperty(obj, property)) == null || value.toString().equals("")) continue;
            BigDecimal b = Utils.toBigDecimal(value);
            if (result == null) {
                result = b;
                continue;
            }
            int v = result.compareTo(b);
            if (v != -1) continue;
            result = b;
        }
        if (result == null) {
            result = new BigDecimal(0);
        }
        return result;
    }
}

