/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.down;

import com.bstek.ureport.build.cell.DuplicateType;
import com.bstek.ureport.build.cell.down.CellDownDuplicator;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownDuplocatorWrapper {
    private String mainCellName;
    private List<CellDownDuplicator> mainCellChildren = new ArrayList<CellDownDuplicator>();
    private List<CellDownDuplicator> cellDuplicators = new ArrayList<CellDownDuplicator>();
    private Map<Cell, List<CellDownDuplicator>> createNewDuplicatorsMap = new HashMap<Cell, List<CellDownDuplicator>>();
    private List<Cell> duplicatorCells = new ArrayList<Cell>();

    public DownDuplocatorWrapper(String mainCellName) {
        this.mainCellName = mainCellName;
    }

    public void addCellDownDuplicator(CellDownDuplicator duplicator) {
        if (duplicator.getDuplicateType().equals((Object)DuplicateType.Duplicate)) {
            this.addCellDownDuplicatorToMap(duplicator);
        } else {
            this.cellDuplicators.add(duplicator);
            this.duplicatorCells.add(duplicator.getCell());
        }
    }

    private void addCellDownDuplicatorToMap(CellDownDuplicator duplicator) {
        Cell leftParentCell = duplicator.getCell().getLeftParentCell();
        if (leftParentCell.getName().equals(this.mainCellName)) {
            this.mainCellChildren.add(duplicator);
        }
        List<Object> list = null;
        if (this.createNewDuplicatorsMap.containsKey(leftParentCell)) {
            list = this.createNewDuplicatorsMap.get(leftParentCell);
        } else {
            list = new ArrayList();
            this.createNewDuplicatorsMap.put(leftParentCell, list);
        }
        list.add(duplicator);
    }

    public boolean contains(Cell cell) {
        return this.duplicatorCells.contains(cell);
    }

    public List<CellDownDuplicator> getMainCellChildren() {
        return this.mainCellChildren;
    }

    public List<CellDownDuplicator> fetchChildrenDuplicator(Cell leftParentCell) {
        return this.createNewDuplicatorsMap.get(leftParentCell);
    }

    public List<CellDownDuplicator> getCellDuplicators() {
        return this.cellDuplicators;
    }
}

