/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.right.CellRightDuplicator;
import com.bstek.ureport.build.cell.right.RightDuplicate;
import com.bstek.ureport.build.cell.right.RightDuplocatorWrapper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import java.util.List;

public class CellRightDuplicateUnit {
    private Cell mainCell;
    private int mainCellColNumber;
    private Context context;
    private RightDuplicate rightDuplicate;
    private RightDuplocatorWrapper rightDuplocatorWrapper;

    public CellRightDuplicateUnit(Context context, RightDuplocatorWrapper rightDuplocatorWrapper, Cell mainCell, int mainCellColNumber, int colSize) {
        this.context = context;
        this.rightDuplocatorWrapper = rightDuplocatorWrapper;
        this.mainCell = mainCell;
        this.mainCellColNumber = mainCellColNumber;
        this.rightDuplicate = new RightDuplicate(mainCell, colSize, context);
    }

    public void duplicate(Cell cell, int index) {
        this.rightDuplicate.setIndex(index);
        for (CellRightDuplicator childDuplicator : this.rightDuplocatorWrapper.getMainCellChildren()) {
            Cell newCell = childDuplicator.duplicateChildrenCell(this.rightDuplicate, cell, this.mainCell, false);
            this.processChildrenCells(newCell, childDuplicator.getCell(), this.rightDuplicate, this.context, childDuplicator.isNonChild());
            childDuplicator.setNonChild(false);
        }
        for (CellRightDuplicator cellRightDuplicator : this.rightDuplocatorWrapper.getCellDuplicators()) {
            cellRightDuplicator.duplicate(this.rightDuplicate, cell);
        }
        Column newCol = this.rightDuplicate.newColumn(cell.getColumn(), this.mainCellColNumber);
        cell.setColumn(newCol);
        newCol.getCells().add(cell);
        cell.getRow().getCells().add(cell);
        this.context.addReportCell(cell);
        this.rightDuplicate.reset();
    }

    public void complete() {
        this.rightDuplicate.complete();
    }

    private void processChildrenCells(Cell cell, Cell originalCell, RightDuplicate rightDuplicate, Context context, boolean parentNonChild) {
        List<CellRightDuplicator> childCellRightDuplicators = this.rightDuplocatorWrapper.fetchChildrenDuplicator(originalCell);
        if (childCellRightDuplicators == null) {
            return;
        }
        for (CellRightDuplicator duplicator : childCellRightDuplicators) {
            Cell newCell = duplicator.duplicateChildrenCell(rightDuplicate, cell, originalCell, parentNonChild);
            this.processChildrenCells(newCell, duplicator.getCell(), rightDuplicate, context, duplicator.isNonChild());
            duplicator.setNonChild(false);
        }
    }
}

