/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.paging.HeaderFooter;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BasePagination {
    protected void buildSummaryRows(List<Row> summaryRows, List<Page> pages) {
        int summaryRowSize;
        Page lastPage = pages.get(pages.size() - 1);
        List<Row> lastPageRows = lastPage.getRows();
        for (int i = summaryRowSize = summaryRows.size() - 1; i > -1; --i) {
            Row row = summaryRows.get(i);
            lastPageRows.add(row);
        }
    }

    protected Page buildPage(List<Row> rows, List<Row> headerRows, List<Row> footerRows, List<Row> titleRows, int pageIndex, Report report) {
        Map<Column, Cell> colMap;
        Row newRow;
        int headerRowSize;
        int rowSize = rows.size();
        Row lastRow = rows.get(rowSize - 1);
        int lastRowNumber = lastRow.getRowNumber();
        List<Column> columns = report.getColumns();
        Context context = report.getContext();
        context.setPageIndex(pageIndex);
        context.setCurrentPageRows(rows);
        Map<Row, Map<Column, Cell>> rowColCellsMap = report.getRowColCellMap();
        List<Row> reportRows = report.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Map<Column, Cell> colMap2 = rowColCellsMap.get(row);
            if (colMap2 == null) continue;
            for (Column col : columns) {
                int span;
                int pageRowNumber;
                int maxRow;
                Cell cell = colMap2.get(col);
                if (cell == null) continue;
                this.buildExistPageFunctionCell(context, cell);
                int rowSpan = cell.getPageRowSpan();
                if (rowSpan == 0 || (maxRow = (pageRowNumber = i + 1) + (span = rowSpan - 1)) <= rowSize) continue;
                Cell newCell = cell.newCell();
                newCell.setFormatData(cell.getFormatData());
                newCell.setForPaging(true);
                int leftSpan = rowSize - pageRowNumber;
                if (leftSpan > 0) {
                    cell.setPageRowSpan(++leftSpan);
                } else {
                    cell.setPageRowSpan(0);
                }
                newCell.setData(cell.getData());
                int newSpan = maxRow - rowSize;
                if (newSpan > 1) {
                    newCell.setPageRowSpan(newSpan);
                    newCell.setRowSpan(newSpan);
                } else {
                    newCell.setPageRowSpan(0);
                    newCell.setRowSpan(0);
                }
                int nextRowNumber = lastRowNumber + 1;
                Row nextRow = this.fetchNextRow(reportRows, nextRowNumber - 1);
                newCell.setRow(nextRow);
                Map<Object, Object> cmap = null;
                if (rowColCellsMap.containsKey(nextRow)) {
                    cmap = rowColCellsMap.get(nextRow);
                } else {
                    cmap = new HashMap();
                    rowColCellsMap.put(nextRow, cmap);
                }
                cmap.put(newCell.getColumn(), newCell);
            }
        }
        for (int i = headerRowSize = headerRows.size() - 1; i > -1; --i) {
            Row row = headerRows.get(i);
            newRow = this.duplicateRepeateRow(row, context);
            rows.add(0, newRow);
            colMap = rowColCellsMap.get(newRow);
            if (colMap == null) continue;
            for (Column col : columns) {
                Cell cell = colMap.get(col);
                if (cell == null) continue;
                this.buildExistPageFunctionCell(context, cell);
            }
        }
        if (pageIndex == 1) {
            int titleRowSize;
            for (int i = titleRowSize = titleRows.size() - 1; i > -1; --i) {
                Row row = titleRows.get(i);
                rows.add(0, row);
                colMap = rowColCellsMap.get(row);
                if (colMap == null) continue;
                for (Column col : columns) {
                    Cell cell = colMap.get(col);
                    if (cell == null) continue;
                    this.buildExistPageFunctionCell(context, cell);
                }
            }
        }
        for (Row row : footerRows) {
            newRow = this.duplicateRepeateRow(row, context);
            rows.add(newRow);
            colMap = rowColCellsMap.get(newRow);
            if (colMap == null) continue;
            for (Column col : columns) {
                Cell cell = colMap.get(col);
                if (cell == null) continue;
                this.buildExistPageFunctionCell(context, cell);
            }
        }
        Page page = new Page(rows, columns);
        return page;
    }

    private Row fetchNextRow(List<Row> reportRows, int rowNumber) {
        Row row = null;
        while (rowNumber < reportRows.size()) {
            row = reportRows.get(rowNumber);
            ++rowNumber;
            if (row.getRealHeight() == 0) continue;
        }
        return row;
    }

    private Row duplicateRepeateRow(Row row, Context context) {
        Row newRow = row.newRow();
        Map<Row, Map<Column, Cell>> cellMap = context.getReport().getRowColCellMap();
        Map<Column, Cell> map = cellMap.get(row);
        if (map == null) {
            return newRow;
        }
        HashMap<Column, Cell> newMap = new HashMap<Column, Cell>();
        cellMap.put(newRow, newMap);
        List<Column> columns = context.getReport().getColumns();
        for (Column col : columns) {
            Cell cell = map.get(col);
            if (cell == null) continue;
            Cell newCell = cell.newCell();
            newCell.setRow(newRow);
            newCell.setFormatData(cell.getFormatData());
            newCell.setData(cell.getData());
            newCell.setCustomCellStyle(cell.getCustomCellStyle());
            newCell.setFormatData(cell.getFormatData());
            newCell.setExistPageFunction(cell.isExistPageFunction());
            newMap.put(col, newCell);
        }
        return newRow;
    }

    private void buildExistPageFunctionCell(Context context, Cell cell) {
        if (cell.isExistPageFunction()) {
            List<BindData> dataList = context.buildCellData(cell);
            if (dataList == null || dataList.size() == 0) {
                return;
            }
            BindData bindData = dataList.get(0);
            cell.setData(bindData.getValue());
            cell.setBindData(bindData.getDataList());
            cell.doFormat();
            cell.doDataWrapCompute(context);
        }
    }

    protected void buildPageHeaderFooter(List<Page> pages, Report report) {
        int totalPages = pages.size();
        for (int i = 0; i < totalPages; ++i) {
            HeaderFooterDefinition footerDef;
            Page page = pages.get(i);
            HeaderFooterDefinition headerDef = report.getHeader();
            int pageIndex = i + 1;
            if (headerDef != null) {
                HeaderFooter hf = headerDef.buildHeaderFooter(pageIndex, totalPages, report.getContext());
                page.setHeader(hf);
            }
            if ((footerDef = report.getFooter()) == null) continue;
            HeaderFooter hf = footerDef.buildHeaderFooter(pageIndex, totalPages, report.getContext());
            page.setFooter(hf);
        }
    }
}

