/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.cache;

import com.bstek.ureport.cache.DefaultMemoryReportDefinitionCache;
import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.cache.ReportDefinitionCache;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.model.Report;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheUtils
implements ApplicationContextAware {
    private static ReportCache reportCache;
    private static ReportDefinitionCache reportDefinitionCache;

    public static Report getReport(String file) {
        if (reportCache != null) {
            return reportCache.getReport(file);
        }
        return null;
    }

    public static void storeReport(String file, Report report) {
        if (reportCache != null) {
            reportCache.storeReport(file, report);
        }
    }

    public static ReportDefinition getReportDefinition(String file) {
        return reportDefinitionCache.getReportDefinition(file);
    }

    public static void cacheReportDefinition(String file, ReportDefinition reportDefinition) {
        reportDefinitionCache.cacheReportDefinition(file, reportDefinition);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection reportCaches;
        Collection coll = applicationContext.getBeansOfType(ReportCache.class).values();
        for (ReportCache cache : coll) {
            if (cache.disabled()) continue;
            reportCache = cache;
            break;
        }
        reportDefinitionCache = (reportCaches = applicationContext.getBeansOfType(ReportDefinitionCache.class).values()).size() == 0 ? new DefaultMemoryReportDefinitionCache() : (ReportDefinitionCache)reportCaches.iterator().next();
    }
}

