/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.chart.dataset.impl;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.chart.dataset.BaseDataset;
import com.bstek.ureport.chart.dataset.BubbleData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class BubbleDataset
extends BaseDataset {
    private String datasetName;
    private String xProperty;
    private String yProperty;
    private String rProperty;
    private String categoryProperty;

    @Override
    public String buildDataJson(Context context, Cell cell) {
        LinkedHashMap map = new LinkedHashMap();
        List<?> dataList = DataUtils.fetchData(cell, context, this.datasetName);
        for (Object obj : dataList) {
            Object categoryValue;
            if (obj == null || (categoryValue = Utils.getProperty(obj, this.categoryProperty)) == null) continue;
            Object xValue = Utils.getProperty(obj, this.xProperty);
            Object yValue = Utils.getProperty(obj, this.yProperty);
            Object rValue = Utils.getProperty(obj, this.rProperty);
            if (xValue == null || yValue == null || rValue == null) continue;
            List<BubbleData> list = null;
            if (map.containsKey(categoryValue)) {
                list = (List)map.get(categoryValue);
            } else {
                list = new ArrayList();
                map.put(categoryValue, list);
            }
            double x = Utils.toBigDecimal(xValue).doubleValue();
            double y = Utils.toBigDecimal(yValue).doubleValue();
            double r = Utils.toBigDecimal(rValue).doubleValue();
            list.add(new BubbleData(x, y, r));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"datasets\":[");
        int index = 0;
        for (Object obj : map.keySet()) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("{");
            sb.append("\"borderColor\":\"rgb(" + this.getRgbColor(index) + ")\",");
            sb.append("\"backgroundColor\":\"rgba(" + this.getRgbColor(index) + ",0.5)\",");
            sb.append("\"label\":\"" + obj + "\",");
            sb.append("\"data\":[");
            List list = (List)map.get(obj);
            int i = 0;
            for (BubbleData data : list) {
                if (i > 0) {
                    sb.append(",");
                }
                ++i;
                sb.append("{");
                sb.append("\"x\":" + data.getX() + ",");
                sb.append("\"y\":" + data.getY() + ",");
                sb.append("\"r\":" + data.getR());
                sb.append("}");
            }
            sb.append("]");
            sb.append("}");
            ++index;
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String getType() {
        return "bubble";
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getCategoryProperty() {
        return this.categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public String getxProperty() {
        return this.xProperty;
    }

    public void setxProperty(String xProperty) {
        this.xProperty = xProperty;
    }

    public String getyProperty() {
        return this.yProperty;
    }

    public void setyProperty(String yProperty) {
        this.yProperty = yProperty;
    }

    public String getrProperty() {
        return this.rProperty;
    }

    public void setrProperty(String rProperty) {
        this.rProperty = rProperty;
    }
}

