/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition;

import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.bstek.ureport.export.html.SearchFormData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ReportDefinition
implements Serializable {
    private static final long serialVersionUID = 5934291400824773809L;
    private String reportFullName;
    private Paper paper;
    private CellDefinition rootCell;
    private HeaderFooterDefinition header;
    private HeaderFooterDefinition footer;
    private SearchForm searchForm;
    private List<CellDefinition> cells;
    private List<RowDefinition> rows;
    private List<ColumnDefinition> columns;
    private List<DatasourceDefinition> datasources;
    private String searchFormXml;
    @JsonIgnore
    private String style;

    public Report newReport() {
        Cell targetCell;
        Report report = new Report();
        report.setReportFullName(this.reportFullName);
        report.setPaper(this.paper);
        report.setHeader(this.header);
        report.setFooter(this.footer);
        ArrayList<Row> reportRows = new ArrayList<Row>();
        ArrayList<Column> reportColumns = new ArrayList<Column>();
        report.setRows(reportRows);
        report.setColumns(reportColumns);
        HashMap<Integer, Row> rowMap = new HashMap<Integer, Row>();
        int headerRowsHeight = 0;
        int footerRowsHeight = 0;
        int titleRowsHeight = 0;
        int summaryRowsHeight = 0;
        for (RowDefinition rowDefinition : this.rows) {
            Row newRow = rowDefinition.newRow(reportRows);
            report.insertRow(newRow, rowDefinition.getRowNumber());
            rowMap.put(rowDefinition.getRowNumber(), newRow);
            Band band = rowDefinition.getBand();
            if (band == null) continue;
            if (band.equals((Object)Band.headerrepeat)) {
                report.getHeaderRepeatRows().add(newRow);
                headerRowsHeight += newRow.getRealHeight();
                continue;
            }
            if (band.equals((Object)Band.footerrepeat)) {
                report.getFooterRepeatRows().add(newRow);
                footerRowsHeight += newRow.getRealHeight();
                continue;
            }
            if (band.equals((Object)Band.title)) {
                report.getTitleRows().add(newRow);
                titleRowsHeight += newRow.getRealHeight();
                continue;
            }
            if (!band.equals((Object)Band.summary)) continue;
            report.getSummaryRows().add(newRow);
            summaryRowsHeight += newRow.getRealHeight();
        }
        report.setRepeatHeaderRowHeight(headerRowsHeight);
        report.setRepeatFooterRowHeight(footerRowsHeight);
        report.setTitleRowsHeight(titleRowsHeight);
        report.setSummaryRowsHeight(summaryRowsHeight);
        HashMap<Integer, Column> columnMap = new HashMap<Integer, Column>();
        for (ColumnDefinition columnDef : this.columns) {
            Column newColumn = columnDef.newColumn(reportColumns);
            report.insertColumn(newColumn, columnDef.getColumnNumber());
            columnMap.put(columnDef.getColumnNumber(), newColumn);
        }
        HashMap<CellDefinition, Cell> hashMap = new HashMap<CellDefinition, Cell>();
        for (CellDefinition cellDef : this.cells) {
            Cell cell = cellDef.newCell();
            hashMap.put(cellDef, cell);
            Row targetRow = (Row)rowMap.get(cellDef.getRowNumber());
            cell.setRow(targetRow);
            targetRow.getCells().add(cell);
            Column targetColumn = (Column)columnMap.get(cellDef.getColumnNumber());
            cell.setColumn(targetColumn);
            targetColumn.getCells().add(cell);
            if (cellDef.getLeftParentCell() == null && cellDef.getTopParentCell() == null) {
                report.setRootCell(cell);
            }
            report.addCell(cell);
        }
        for (CellDefinition cellDef : this.cells) {
            targetCell = (Cell)hashMap.get(cellDef);
            CellDefinition leftParentCellDef = cellDef.getLeftParentCell();
            if (leftParentCellDef != null) {
                targetCell.setLeftParentCell((Cell)hashMap.get(leftParentCellDef));
            } else {
                targetCell.setLeftParentCell(null);
            }
            CellDefinition topParentCellDef = cellDef.getTopParentCell();
            if (topParentCellDef != null) {
                targetCell.setTopParentCell((Cell)hashMap.get(topParentCellDef));
                continue;
            }
            targetCell.setTopParentCell(null);
        }
        for (CellDefinition cellDef : this.cells) {
            targetCell = (Cell)hashMap.get(cellDef);
            List<CellDefinition> rowChildrenCellDefinitions = cellDef.getRowChildrenCells();
            for (CellDefinition childCellDef : rowChildrenCellDefinitions) {
                Cell childCell = (Cell)hashMap.get(childCellDef);
                targetCell.addRowChild(childCell);
            }
            List<CellDefinition> columnChildrenCellDefinitions = cellDef.getColumnChildrenCells();
            for (CellDefinition childCellDef : columnChildrenCellDefinitions) {
                Cell childCell = (Cell)hashMap.get(childCellDef);
                targetCell.addColumnChild(childCell);
            }
        }
        return report;
    }

    public String getStyle() {
        if (this.style == null) {
            this.style = this.buildStyle();
        }
        return this.style;
    }

    private String buildStyle() {
        StringBuffer sb = new StringBuffer();
        for (CellDefinition cell : this.cells) {
            Border border;
            String fontFamilty;
            String bgcolor;
            float lineHeight;
            Alignment valign;
            CellStyle cellStyle = cell.getCellStyle();
            sb.append("._" + cell.getName() + "{");
            int colWidth = this.getColumnWidth(cell.getColumnNumber(), cell.getColSpan());
            sb.append("width:" + colWidth + "pt;");
            Alignment align = cellStyle.getAlign();
            if (align != null) {
                sb.append("text-align:" + align.name() + ";");
            }
            if ((valign = cellStyle.getValign()) != null) {
                sb.append("vertical-align:" + valign.name() + ";");
            }
            if ((lineHeight = cellStyle.getLineHeight()) > 0.0f) {
                sb.append("line-height:" + lineHeight + ";");
            }
            if (StringUtils.isNotBlank((String)(bgcolor = cellStyle.getBgcolor()))) {
                sb.append("background-color:rgb(" + bgcolor + ");");
            }
            if (StringUtils.isNotBlank((String)(fontFamilty = cellStyle.getFontFamily()))) {
                sb.append("font-family:" + fontFamilty + ";");
            }
            int fontSize = cellStyle.getFontSize();
            sb.append("font-size:" + fontSize + "pt;");
            String foreColor = cellStyle.getForecolor();
            if (StringUtils.isNotBlank((String)foreColor)) {
                sb.append("color:rgb(" + foreColor + ");");
            }
            Boolean bold = cellStyle.getBold();
            Boolean italic = cellStyle.getItalic();
            Boolean underline = cellStyle.getUnderline();
            if (bold != null && bold.booleanValue()) {
                sb.append("font-weight:bold;");
            }
            if (italic != null && italic.booleanValue()) {
                sb.append("font-style:italic;");
            }
            if (underline != null && underline.booleanValue()) {
                sb.append("text-decoration:underline;");
            }
            if ((border = cellStyle.getLeftBorder()) != null) {
                sb.append("border-left:" + border.getStyle().name() + " " + border.getWidth() + "px rgb(" + border.getColor() + ");");
            }
            if ((border = cellStyle.getRightBorder()) != null) {
                sb.append("border-right:" + border.getStyle().name() + " " + border.getWidth() + "px rgb(" + border.getColor() + ");");
            }
            if ((border = cellStyle.getTopBorder()) != null) {
                sb.append("border-top:" + border.getStyle().name() + " " + border.getWidth() + "px rgb(" + border.getColor() + ");");
            }
            if ((border = cellStyle.getBottomBorder()) != null) {
                sb.append("border-bottom:" + border.getStyle().name() + " " + border.getWidth() + "px rgb(" + border.getColor() + ");");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public SearchFormData buildSearchFormData() {
        if (this.searchForm == null) {
            return null;
        }
        RenderContext context = new RenderContext();
        SearchFormData data = new SearchFormData();
        data.setFormPosition(this.searchForm.getFormPosition());
        data.setHtml(this.searchForm.toHtml(context));
        data.setJs(this.searchForm.toJs(context));
        data.setSearchFormXml(this.searchFormXml);
        return data;
    }

    private int getColumnWidth(int columnNumber, int colSpan) {
        int width = 0;
        if (colSpan > 0) {
            --colSpan;
        }
        int start = columnNumber;
        int end = start + colSpan;
        for (int i = start; i <= end; ++i) {
            for (ColumnDefinition col : this.columns) {
                if (col.getColumnNumber() != i) continue;
                width += col.getWidth();
            }
        }
        return width;
    }

    public String getReportFullName() {
        return this.reportFullName;
    }

    public void setReportFullName(String reportFullName) {
        this.reportFullName = reportFullName;
    }

    public Paper getPaper() {
        return this.paper;
    }

    public void setPaper(Paper paper) {
        this.paper = paper;
    }

    public CellDefinition getRootCell() {
        return this.rootCell;
    }

    public void setRootCell(CellDefinition rootCell) {
        this.rootCell = rootCell;
    }

    public HeaderFooterDefinition getHeader() {
        return this.header;
    }

    public void setHeader(HeaderFooterDefinition header) {
        this.header = header;
    }

    public HeaderFooterDefinition getFooter() {
        return this.footer;
    }

    public void setFooter(HeaderFooterDefinition footer) {
        this.footer = footer;
    }

    public SearchForm getSearchForm() {
        return this.searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public List<RowDefinition> getRows() {
        return this.rows;
    }

    public void setRows(List<RowDefinition> rows) {
        this.rows = rows;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public List<CellDefinition> getCells() {
        return this.cells;
    }

    public void setCells(List<CellDefinition> cells) {
        this.cells = cells;
    }

    public void setDatasources(List<DatasourceDefinition> datasources) {
        this.datasources = datasources;
    }

    public List<DatasourceDefinition> getDatasources() {
        return this.datasources;
    }

    public String getSearchFormXml() {
        return this.searchFormXml;
    }

    public void setSearchFormXml(String searchFormXml) {
        this.searchFormXml = searchFormXml;
    }
}

