/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.datasource;

import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.SqlDatasetDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceType;
import com.bstek.ureport.exception.ReportComputeException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BuildinDatasourceDefinition
implements DatasourceDefinition {
    private String name;
    private List<DatasetDefinition> datasets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> buildDatasets(Connection conn, Map<String, Object> parameters) {
        if (this.datasets == null || this.datasets.size() == 0) {
            return null;
        }
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        try {
            for (DatasetDefinition dsDef : this.datasets) {
                SqlDatasetDefinition sqlDataset = (SqlDatasetDefinition)dsDef;
                Dataset ds = sqlDataset.buildDataset(parameters, conn);
                list.add(ds);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ReportComputeException(e);
            }
        }
        return list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<DatasetDefinition> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<DatasetDefinition> datasets) {
        this.datasets = datasets;
    }

    @Override
    public DatasourceType getType() {
        return DatasourceType.buildin;
    }
}

